/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.Overloaded;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.internal.command.CommandFactory;

public class MvelOverloadedMethodsUsageTest
extends KieSessionTest {
    private static final String DRL = "package org.drools.testcoverage.regression;\nimport org.drools.testcoverage.common.model.Overloaded;\nrule MvelOverloadedMethods\n    dialect \"mvel\"    when\n        o : Overloaded()\n        eval (o.method(5, 9, \"x\") == 15)\n        eval (o.method(\"x\", 5, 9) == -13)\n        eval (o.method(5, \"x\", 9) == -3)\n    then\nend\nrule MvelOverloadedMethods2\n    dialect \"mvel\"    when\n        o : Overloaded()\n        eval (\"helloworld150.32\".equals(o.method2(\"hello\", \"world\", 15L, 0.32)))\n        eval (\"32hello0.53world\".equals(o.method2(32L, \"hello\", 0.53, \"world\")))\n    then\nend\n";

    public MvelOverloadedMethodsUsageTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndKieSessionConfigurations();
    }

    @Test
    public void testMvelOverloadedMethodsUsage() {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)new Overloaded()));
        commands.add(CommandFactory.newFireAllRules());
        this.session.execute(CommandFactory.newBatchExecution(commands));
        Assertions.assertThat((int)this.firedRules.ruleFiredCount("MvelOverloadedMethods")).isEqualTo(1);
        Assertions.assertThat((int)this.firedRules.ruleFiredCount("MvelOverloadedMethods2")).isEqualTo(1);
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL);
    }
}

