/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class EqualityKeyOverrideTest
extends KieSessionTest {
    private static final int ANY_NUMBER = 42;
    private static final String DRL = "package org.drools.testcoverage.regression;\ndeclare Superclass\nend\ndeclare Subclass extends Superclass\nend\nrule insertSubclass\n    when\n        String()\n    then\n        insertLogical(new Subclass());\nend\nrule insertSuperclass\n    when\n        Integer()\n    then\n        insertLogical(new Superclass());\nend\n";

    public EqualityKeyOverrideTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndStatefulKieSessionConfigurations();
    }

    @Test
    public void testEqualityOverride() {
        KieSession ksession = this.session.getStateful();
        FactHandle string = ksession.insert((Object)"testString");
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
        ksession.insert((Object)42);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(4);
        ksession.delete(string);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL);
    }
}

