/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;

public class MultiRestrictionPatternTest
extends KieSessionTest {
    private static final String DRL_FILE = "BRMS-364.drl";

    public MultiRestrictionPatternTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndStatefulKieSessionConfigurations();
    }

    @Test
    public void multiRestriction1() throws Exception {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(KieUtil.getCommands().newInsert((Object)new Person("multi")));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)this.firedRules.isRuleFired("or1")).isTrue();
    }

    @Test
    public void multiRestriction2() throws Exception {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(KieUtil.getCommands().newInsert((Object)new Person("MULTIRESTRICTION")));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)this.firedRules.isRuleFired("or2")).isTrue();
    }

    @Test
    public void multiRestriction3() throws Exception {
        ArrayList<Command> commands = new ArrayList<Command>();
        Person p = new Person();
        p.setId(3);
        commands.add(KieUtil.getCommands().newInsert((Object)p));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)this.firedRules.isRuleFired("and")).isTrue();
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL_FILE, MultiRestrictionPatternTest.class);
    }
}

