/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;

@RunWith(value=Parameterized.class)
public class DateExtendingFactTest {
    private static final String FACT_CLASS_NAME = MyDate.class.getCanonicalName();
    private static final String DRL = "package org.test\nrule 'sample rule'\nwhen\n  $date:" + FACT_CLASS_NAME + "()\nthen\n$date.setDescription(\"test\");\nend\n";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DateExtendingFactTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testDateExtendingFact() {
        Resource resource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(DRL));
        resource.setTargetPath("src/main/resources/rule.drl");
        KieBuilder kbuilder = KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, resource);
        Assertions.assertThat((List)kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEmpty();
    }

    public static class MyDate
    extends Date {
        private String description;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }
    }
}

