/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.utils.KieHelper;

public class SerializationWithCollectTest {
    private static final String DRL = "import java.util.Collection\nrule R1 when\n Collection(empty==false) from collect( Integer() )\n Collection() from collect( String() )\nthen\nend\nrule R2 when then end\n";
    private KieBase kbase;
    private KieSession ksession;

    @Before
    public void setup() {
        this.kbase = new KieHelper().addContent(DRL, ResourceType.DRL).build(new KieBaseOption[0]);
        this.ksession = this.kbase.newKieSession();
    }

    @After
    public void cleanup() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void test() throws Exception {
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)this.kbase);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.marshall((OutputStream)baos, this.ksession);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                marshaller = MarshallerFactory.newMarshaller((KieBase)this.kbase);
                this.ksession = marshaller.unmarshall((InputStream)bais);
            }
        }
        catch (NullPointerException e) {
            Assertions.fail((String)"Consider reopening BZ 1193600!", (Throwable)e);
        }
    }
}

