/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ParserTest {
    private static final String PARSER_RESOURCES_DIR_PATH = "src/test/resources/org/drools/testcoverage/functional/parser";
    private static final File PARSER_RESOURCES_DIR = new File("src/test/resources/org/drools/testcoverage/functional/parser");
    protected final File file;
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ParserTest(File file, KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.file = file;
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    protected static List<File> getFiles(String directory) {
        return ParserTest.getFiles(directory, null);
    }

    protected static List<File> getFiles(String directory, String extension) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = new File(PARSER_RESOURCES_DIR, directory).listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().startsWith(".") || extension != null && !f.getName().endsWith("." + extension)) continue;
                result.add(f);
            }
        }
        return result;
    }

    protected static Collection<Object[]> getTestParamsFromFiles(Collection<File> files) {
        HashSet<Object[]> set = new HashSet<Object[]>();
        for (File file : files) {
            set.add(new Object[]{file, KieBaseTestConfiguration.CLOUD_EQUALITY});
            set.add(new Object[]{file, KieBaseTestConfiguration.CLOUD_EQUALITY_MODEL_PATTERN});
        }
        return set;
    }
}

