/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ActivationGroupTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ActivationGroupTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void basicTestActivationGroup() {
        TrackingAgendaEventListener listener = this.prepareKSession("basicActivationGroup");
        Assertions.assertThat((boolean)listener.isRuleFired("basic1")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("basic2")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("basic3")).isFalse();
    }

    @Test
    public void recursiveTestActivationGroup() {
        TrackingAgendaEventListener listener = this.prepareKSession("recursiveActivationGroup");
        Assertions.assertThat((boolean)listener.isRuleFired("simplyRecursive1")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("simplyRecursive2")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("simplyRecursive3")).isTrue();
    }

    @Test
    public void testActivationGroupWithDefaultSalience() {
        TrackingAgendaEventListener listener = this.prepareKSession("defaultSalienceActivationGroup");
        Assertions.assertThat((int)listener.rulesCount()).isEqualTo(1);
    }

    @Test
    public void testActivationGroupRecursivelyWithDefaultSalience() {
        TrackingAgendaEventListener listener = this.prepareKSession("defaultSalienceWithRecursion");
        Assertions.assertThat((int)listener.rulesCount()).isEqualTo(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackingAgendaEventListener prepareKSession(String startingRule) {
        ArrayList commands = new ArrayList();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        KieSession ksession = this.getKieBaseForTest().newKieSession();
        try {
            ksession.addEventListener((AgendaEventListener)listener);
            ksession.insert((Object)startingRule);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
        return listener;
    }

    private KieBase getKieBaseForTest() {
        Resource drlResource = KieServices.Factory.get().getResources().newClassPathResource("activation-group.drl", this.getClass());
        return KieBaseUtil.getKieBaseFromKieModuleFromResources("org.drools.testcoverage.functional", this.kieBaseTestConfiguration, drlResource);
    }
}

