/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.KieCommands;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, String groupId, KieModuleModel kieModuleModel, Resource ... resources) {
        ReleaseId releaseId = KieUtil.generateReleaseId(groupId);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, resources);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, ReleaseId releaseId, KieModuleModel kieModuleModel, Resource ... resources) {
        KieFileSystem fileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, releaseId, resources);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, fileSystem);
    }

    public static KieModule buildAndInstallKieModuleIntoRepo(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem kieFileSystem) {
        KieServices kieServices = KieServices.Factory.get();
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kieFileSystem, true);
        KieModule kieModule = builder.getKieModule();
        kieServices.getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieModuleModel createKieModuleModel(Boolean alphaNetworkEnabled) {
        KieServices kieServices = KieServices.Factory.get();
        KieModuleModel kieModuleModel = kieServices.newKieModuleModel();
        if (alphaNetworkEnabled.booleanValue()) {
            kieModuleModel.setConfigurationProperty("drools.alphaNetworkCompiler", AlphaNetworkCompilerOption.INMEMORY.getMode());
        }
        return kieModuleModel;
    }

    public static KieFileSystem getKieFileSystemWithKieModule(KieModuleModel kieModuleModel, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem fileSystem = KieServices.Factory.get().newKieFileSystem();
        fileSystem.generateAndWritePomXML(releaseId);
        for (Resource resource : resources) {
            fileSystem.write(resource);
        }
        fileSystem.writeKModuleXML(kieModuleModel.toXML());
        return fileSystem;
    }

    public static KieBuilder getKieBuilderFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, boolean failIfBuildError, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, failIfBuildError, resources.toArray(new Resource[0]));
    }

    public static KieBuilder getKieBuilderFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, Map<String, String> kieModuleConfigurationProperties, boolean failIfBuildError, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, kieModuleConfigurationProperties, failIfBuildError, resources.toArray(new Resource[0]));
    }

    public static KieBuilder getKieBuilderFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, boolean failIfBuildError, Resource ... resources) {
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel(kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>());
        KieFileSystem kieFileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, KieServices.get().getRepository().getDefaultReleaseId(), resources);
        return KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kieFileSystem, failIfBuildError);
    }

    public static KieBuilder getKieBuilderFromResources(KieBaseTestConfiguration kieBaseTestConfiguration, Map<String, String> kieModuleConfigurationProperties, boolean failIfBuildError, Resource ... resources) {
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel(kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties);
        KieFileSystem kieFileSystem = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, KieServices.get().getRepository().getDefaultReleaseId(), resources);
        return KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kieFileSystem, failIfBuildError);
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem kfs, boolean failIfBuildError) {
        return KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kfs, failIfBuildError, null);
    }

    public static KieBuilder getKieBuilderFromKieFileSystem(KieBaseTestConfiguration kieBaseTestConfiguration, KieFileSystem kfs, boolean failIfBuildError, ClassLoader classLoader) {
        KieBuilder kbuilder = classLoader == null ? KieServices.Factory.get().newKieBuilder(kfs) : KieServices.Factory.get().newKieBuilder(kfs, classLoader);
        if (kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            kbuilder.buildAll(kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        } else {
            kbuilder.buildAll(DrlProject.class);
        }
        List msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.INFO});
        if (msgs.size() > 0) {
            LOGGER.info("KieBuilder information: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.WARNING})).size() > 0) {
            LOGGER.warn("KieBuilder warnings: {}", (Object)msgs.toString());
        }
        if ((msgs = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).size() > 0) {
            LOGGER.error("KieBuilder errors: {}", (Object)msgs.toString());
        }
        if (failIfBuildError) {
            ((ListAssert)Assertions.assertThat((List)msgs).as(msgs.toString(), new Object[0])).isEmpty();
        }
        return kbuilder;
    }

    public static ReleaseId generateReleaseId(String groupId) {
        KieServices kieServices = KieServices.Factory.get();
        return kieServices.newReleaseId(groupId, UUID.randomUUID().toString(), "1.0.0");
    }

    public static KieBuilder getKieBuilderFromClasspathResources(KieBaseTestConfiguration kieBaseTestConfiguration, Class classLoaderFromClass, boolean failIfBuildError, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieUtil.getKieBuilderFromResources(kieBaseTestConfiguration, failIfBuildError, result.toArray(new Resource[0]));
    }

    public static Resource[] createResources(String drlFile, Class<?> clazz) {
        return new Resource[]{KieUtil.getResources().newClassPathResource(drlFile, clazz)};
    }

    public static Resource[] createResources(String drl) {
        Resource drlResource = KieUtil.getResources().newReaderResource((Reader)new StringReader(drl));
        drlResource.setTargetPath("src/main/resources/rule.drl");
        return new Resource[]{drlResource};
    }

    public static KieContainer getKieContainerFromDrls(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, String ... drls) {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(UUID.randomUUID().toString(), "test-artifact", "1.0");
        KieModule kieModule = KieUtil.getKieModuleFromDrls(releaseId, kieBaseTestConfiguration, kieSessionTestConfiguration, new HashMap<String, String>(), drls);
        return kieServices.newKieContainer(kieModule.getReleaseId());
    }

    public static KieModule getKieModuleFromDrls(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        return KieUtil.getKieModuleFromDrls(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, drls);
    }

    public static KieModule getKieModuleFromDrls(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, String ... drls) {
        return KieUtil.getKieModuleFromDrls(releaseId, kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>(), drls);
    }

    public static KieModule getKieModuleFromDrls(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties, String ... drls) {
        List<Resource> resources = KieUtil.getResourcesFromDrls(drls);
        return KieUtil.getKieModuleFromResources(releaseId, kieBaseTestConfiguration, kieSessionTestConfiguration, kieModuleConfigurationProperties, resources.toArray(new Resource[0]));
    }

    public static KieModule getKieModuleFromResources(String moduleGroupId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieUtil.getKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, resources);
    }

    public static KieModule getKieModuleFromResources(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        return KieUtil.getKieModuleFromResources(releaseId, kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>(), resources);
    }

    public static KieModule getKieModuleFromResources(ReleaseId releaseId, KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties, Resource ... resources) {
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel(kieBaseTestConfiguration, kieSessionTestConfiguration, kieModuleConfigurationProperties);
        return KieUtil.buildAndInstallKieModuleIntoRepo(kieBaseTestConfiguration, releaseId, kieModuleModel, resources);
    }

    public static KieModule getKieModuleFromClasspathResources(String moduleGroupId, Class<?> classLoaderFromClass, KieBaseTestConfiguration kieBaseTestConfiguration, String ... resources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (String resource : resources) {
            result.add(KieServices.Factory.get().getResources().newClassPathResource(resource, classLoaderFromClass));
        }
        return KieUtil.getKieModuleFromResources(KieUtil.generateReleaseId(moduleGroupId), kieBaseTestConfiguration, result.toArray(new Resource[0]));
    }

    public static KieModule getKieModuleFromResourcesWithClassLoaderForKieBuilder(String moduleGroupId, ClassLoader classLoaderForKieBuilder, KieBaseTestConfiguration kieBaseTestConfiguration, Resource ... resources) {
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel(kieBaseTestConfiguration, KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap<String, String>());
        KieFileSystem kfs = KieUtil.getKieFileSystemWithKieModule(kieModuleModel, KieUtil.generateReleaseId(moduleGroupId), resources);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem(kieBaseTestConfiguration, kfs, false, classLoaderForKieBuilder);
        KieModule kieModule = kieBuilder.getKieModule();
        KieServices.Factory.get().getRepository().addKieModule(kieModule);
        return kieModule;
    }

    public static KieModuleModel getKieModuleModel(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration, Map<String, String> kieModuleConfigurationProperties) {
        KieModuleModel module = KieUtil.createKieModuleModel(kieBaseTestConfiguration.useAlphaNetworkCompiler());
        kieModuleConfigurationProperties.forEach((arg_0, arg_1) -> ((KieModuleModel)module).setConfigurationProperty(arg_0, arg_1));
        KieBaseModel kieBaseModel = kieBaseTestConfiguration.getKieBaseModel(module);
        kieSessionTestConfiguration.getKieSessionModel(kieBaseModel);
        return module;
    }

    public static List<Resource> getResourcesFromDrls(String ... drls) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drls[i]));
            drlResource.setSourcePath("src/main/resources/rules" + (i + 1) + ".drl");
            resources.add(drlResource);
        }
        return resources;
    }

    public static List<Resource> getClasspathResources(String ... classpathResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) continue;
            resources.add(KieServices.Factory.get().getResources().newClassPathResource(classpathResource));
        }
        return resources;
    }

    public static List<Resource> getClasspathResources(Class<?> classLoaderFromClass, String ... classpathResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String classpathResource : classpathResources) {
            if (classpathResource == null) continue;
            resources.add(KieServices.Factory.get().getResources().newClassPathResource(classpathResource, classLoaderFromClass));
        }
        return resources;
    }

    public static KieCommands getCommands() {
        return KieUtil.getServices().getCommands();
    }

    public static KieResources getResources() {
        return KieUtil.getServices().getResources();
    }

    public static KieServices getServices() {
        return KieServices.Factory.get();
    }

    public static Resource getResource(String content, String path) {
        KieServices kieServices = KieServices.get();
        Resource resource = kieServices.getResources().newByteArrayResource(content.getBytes());
        resource.setSourcePath(path);
        return resource;
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }

    public static JoinNode getJoinNode(KieBase kbase, Class<?> factClass) {
        Collection entryPointNodes = ((KnowledgeBaseImpl)kbase).getRete().getEntryPointNodes().values();
        for (EntryPointNode entryPointNode : entryPointNodes) {
            JoinNode joinNode = KieUtil.findNode((BaseNode)entryPointNode, JoinNode.class);
            if (!joinNode.getObjectTypeNode().getObjectType().getClassType().equals(factClass)) continue;
            return joinNode;
        }
        return null;
    }

    private static <T> T findNode(BaseNode node, Class<T> nodeClass) {
        Sink[] sinks;
        if (node.getClass().equals(nodeClass)) {
            return (T)node;
        }
        for (Sink sink : sinks = node.getSinks()) {
            if (!(sink instanceof BaseNode)) continue;
            return KieUtil.findNode((BaseNode)sink, nodeClass);
        }
        return null;
    }

    private KieUtil() {
    }
}

