/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.testcoverage.common.listener.OrderListener;
import org.drools.testcoverage.common.listener.TrackingAgendaEventListener;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Sample;
import org.drools.testcoverage.common.model.Subject;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.ResourceUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.DecisionTableInputType;

@RunWith(value=Parameterized.class)
public class DecisionTableTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static Resource sampleXlsDecisionTable;
    private static Resource sampleCsvDecisionTable;
    private static Resource multipleTablesDecisionTable;
    private static Resource evalDecisionTable;
    private static Resource advancedDecisionTable;
    private static Resource sequentialDecisionTable;
    private static Resource agendaGroupDecisionTable;
    private static Resource emptyConditionDecisionTable;
    private static Resource emptyActionDecisionTable;
    private static Resource queriesDecisionTable;
    private static Resource sampleDatesCsvDecisionTable;
    private static Resource sampleDatesXlsDecisionTable;
    private static Resource sampleDateXLSXDecisionTable;

    public DecisionTableTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @BeforeClass
    public static void loadDecisionTablesToAvoidLoadingThemForEachKieBaseConfiguration() {
        sampleXlsDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        sampleCsvDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample.csv", DecisionTableTest.class, DecisionTableInputType.CSV);
        multipleTablesDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("multiple_tables.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        evalDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("eval_dt.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        advancedDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("advanced_dt.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        agendaGroupDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("agenda-group.csv", DecisionTableTest.class, DecisionTableInputType.CSV);
        emptyConditionDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("emptyCondition.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        emptyActionDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("emptyAction.csv", DecisionTableTest.class, DecisionTableInputType.CSV);
        queriesDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("queries.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        sequentialDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sequential.csv", DecisionTableTest.class, DecisionTableInputType.CSV);
        sampleDatesCsvDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample_dates.csv", DecisionTableTest.class, DecisionTableInputType.CSV);
        sampleDatesXlsDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("sample_dates.xls", DecisionTableTest.class, DecisionTableInputType.XLS);
        sampleDateXLSXDecisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("inputObjectExample.xlsx", DecisionTableTest.class, DecisionTableInputType.XLSX);
    }

    @Test
    public void testSimpleXLS() {
        this.testSimpleDecisionTable(sampleXlsDecisionTable);
    }

    @Test
    public void testSimpleCSV() {
        this.testSimpleDecisionTable(sampleCsvDecisionTable);
    }

    private void testSimpleDecisionTable(Resource decisionTable) {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, decisionTable);
        KieSession session = kbase.newKieSession();
        Person person = new Person("Paul");
        person.setId(1);
        Assertions.assertThat((String)person.getName()).isEqualTo("Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(1);
        session.insert((Object)person);
        session.fireAllRules();
        Assertions.assertThat((String)person.getName()).isEqualTo("Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(2);
        session.dispose();
    }

    @Test
    public void testMultipleTableXLS() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, multipleTablesDecisionTable);
        Assertions.assertThat((int)2).isEqualTo(kbase.getKiePackages().size());
        KieSession session = kbase.newKieSession();
        Person person = new Person("Paul");
        person.setId(1);
        Assertions.assertThat((String)person.getName()).isEqualTo("Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(1);
        Person person2 = new Person("Helmut von Seireit");
        person2.setId(1000);
        Assertions.assertThat((String)person2.getName()).isEqualTo("Helmut von Seireit");
        Assertions.assertThat((int)person2.getId()).isEqualTo(1000);
        session.insert((Object)person);
        session.insert((Object)person2);
        session.fireAllRules();
        Assertions.assertThat((String)person.getName()).isEqualTo("Paul");
        Assertions.assertThat((int)person.getId()).isEqualTo(2);
        Assertions.assertThat((String)person2.getName()).isEqualTo("Wilhelm von Seireit");
        Assertions.assertThat((int)person2.getId()).isEqualTo(1000);
        session.dispose();
    }

    @Test
    public void testEvalTable() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, evalDecisionTable);
        Assertions.assertThat((int)2).isEqualTo(kbase.getKiePackages().size());
        KieSession session = kbase.newKieSession();
        TrackingAgendaEventListener rulesFired = new TrackingAgendaEventListener();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject mary = new Subject("Mary");
        mary.setDummy(1);
        session.insert((Object)mary);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject inge = new Subject("Inge");
        inge.setAge(7);
        inge.setSex("F");
        Subject jochen = new Subject("Jochen");
        jochen.setAge(9);
        jochen.setSex("M");
        session.insert((Object)inge);
        session.insert((Object)jochen);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject karl = new Subject("Karl");
        karl.setSex("male");
        Subject egon = new Subject("Egon");
        egon.setSex("male");
        session.insert((Object)karl);
        session.insert((Object)egon);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        Subject gerda = new Subject("Gerda");
        gerda.setSex("female");
        gerda.setAge(9);
        gerda.setDummy(-10);
        session.insert((Object)gerda);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isTrue();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isFalse();
        session.dispose();
        session = kbase.newKieSession();
        session.addEventListener((AgendaEventListener)rulesFired);
        rulesFired.clear();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Sample sample = new Sample();
        session.insert((Object)sample);
        session.fireAllRules();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest1")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest2")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest3")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("evalTest4")).isFalse();
        Assertions.assertThat((boolean)rulesFired.isRuleFired("simpleBindingTest")).isTrue();
        session.dispose();
    }

    @Test
    public void testAdvancedTable() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, advancedDecisionTable);
        KieSession session = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        session.addEventListener((AgendaEventListener)listener);
        Subject lili = new Subject("Lili");
        lili.setAge(100);
        Sample sample = new Sample();
        session.insert((Object)lili);
        session.insert((Object)sample);
        session.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(4);
        String[] expected = new String[]{"HelloWorld_11", "namedRule", "b1", "another rule"};
        for (int i = 0; i < 4; ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo(expected[i]);
        }
        session.dispose();
    }

    @Test
    public void testPushQueryWithFactDeclaration() throws IllegalAccessException, InstantiationException {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, queriesDecisionTable);
        FactType locationType = kbase.getFactType("org.drools.testcoverage.functional", "Location");
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        Person peter = new Person("Peter");
        peter.setLikes("steak");
        Object steakLocation = locationType.newInstance();
        locationType.set(steakLocation, "thing", (Object)"steak");
        locationType.set(steakLocation, "location", (Object)"table");
        Object tableLocation = locationType.newInstance();
        locationType.set(tableLocation, "thing", (Object)"table");
        locationType.set(tableLocation, "location", (Object)"office");
        ksession.insert((Object)peter);
        FactHandle steakHandle = ksession.insert(steakLocation);
        FactHandle tableHandle = ksession.insert(tableLocation);
        ksession.insert((Object)"push");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        Object steakLocation2 = locationType.newInstance();
        locationType.set(steakLocation2, "thing", (Object)"steak");
        locationType.set(steakLocation2, "location", (Object)"desk");
        Object deskLocation = locationType.newInstance();
        locationType.set(deskLocation, "thing", (Object)"desk");
        locationType.set(deskLocation, "location", (Object)"office");
        ksession.insert(steakLocation2);
        ksession.insert(deskLocation);
        ksession.delete(steakHandle);
        ksession.delete(tableHandle);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        Person paul = new Person("Paul");
        paul.setLikes("steak");
        ksession.insert((Object)paul);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        listener.clear();
        ksession.dispose();
    }

    @Test
    public void testPullQueryWithFactDeclaration() throws IllegalAccessException, InstantiationException {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, queriesDecisionTable);
        FactType locationType = kbase.getFactType("org.drools.testcoverage.functional", "Location");
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        Person peter = new Person("Peter");
        peter.setLikes("steak");
        Object steakLocation = locationType.newInstance();
        locationType.set(steakLocation, "thing", (Object)"steak");
        locationType.set(steakLocation, "location", (Object)"table");
        Object tableLocation = locationType.newInstance();
        locationType.set(tableLocation, "thing", (Object)"table");
        locationType.set(tableLocation, "location", (Object)"office");
        ksession.insert((Object)peter);
        FactHandle steakHandle = ksession.insert(steakLocation);
        FactHandle tableHandle = ksession.insert(tableLocation);
        ksession.insert((Object)"pull");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        Object steakLocation2 = locationType.newInstance();
        locationType.set(steakLocation2, "thing", (Object)"steak");
        locationType.set(steakLocation2, "location", (Object)"desk");
        Object deskLocation = locationType.newInstance();
        locationType.set(deskLocation, "thing", (Object)"desk");
        locationType.set(deskLocation, "location", (Object)"office");
        ksession.insert(steakLocation2);
        ksession.insert(deskLocation);
        ksession.delete(steakHandle);
        ksession.delete(tableHandle);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        Person paul = new Person("Paul");
        paul.setLikes("steak");
        ksession.insert((Object)paul);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("testPullQueryRule")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("testPushQueryRule")).isFalse();
        listener.clear();
        ksession.dispose();
    }

    @Test
    public void testSequential() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, sequentialDecisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"something");
        ksession.fireAllRules();
        ((AbstractIntegerAssert)Assertions.assertThat((int)listener.size()).as("Wrong number of rules fired", new Object[0])).isEqualTo(3);
        String[] expected = new String[]{"Rule1", "Rule2", "Rule3"};
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo(expected[i]);
        }
        ksession.dispose();
    }

    @Test
    public void testLockOnActive() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, agendaGroupDecisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"lockOnActive");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(3);
        String[] expected = new String[]{"a", "a2", "a3"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo(expected[i]);
        }
        ksession.dispose();
    }

    @Test
    public void testAutoFocus() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, agendaGroupDecisionTable);
        KieSession ksession = kbase.newKieSession();
        OrderListener listener = new OrderListener();
        ksession.addEventListener((AgendaEventListener)listener);
        FactHandle withoutAutoFocus = ksession.insert((Object)"withoutAutoFocus");
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(0);
        ksession.insert((Object)"autoFocus");
        ksession.delete(withoutAutoFocus);
        ksession.fireAllRules();
        Assertions.assertThat((int)listener.size()).isEqualTo(2);
        String[] expected = new String[]{"b2", "b1"};
        for (int i = 0; i < listener.size(); ++i) {
            Assertions.assertThat((String)listener.get(i)).isEqualTo(expected[i]);
        }
        ksession.dispose();
    }

    @Test
    public void testActivationGroup() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, agendaGroupDecisionTable);
        KieSession ksession = kbase.newKieSession();
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ksession.insert((Object)"activationGroup");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("c1")).isFalse();
        Assertions.assertThat((boolean)listener.isRuleFired("c2")).isTrue();
        Assertions.assertThat((boolean)listener.isRuleFired("c3")).isFalse();
        ksession.dispose();
    }

    @Test(expected=DecisionTableParseException.class)
    public void testEmptyConditionInXLS() {
        KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, emptyConditionDecisionTable);
    }

    @Test(expected=DecisionTableParseException.class)
    public void testEmptyActionInCSV() {
        KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, emptyActionDecisionTable);
    }

    @Test
    public void testCSVWithDateAttributes() {
        this.testDecisionTableWithDateAttributes(sampleDatesCsvDecisionTable);
    }

    @Test
    public void testXLSWithDateAttributes() {
        this.testDecisionTableWithDateAttributes(sampleDatesXlsDecisionTable);
    }

    private void testDecisionTableWithDateAttributes(Resource decisionTable) {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, decisionTable);
        ArrayList<String> names = new ArrayList<String>();
        Collection pkgs = kbase.getKiePackages();
        for (KiePackage kp : pkgs) {
            names.add(kp.getName());
        }
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.functional")).isTrue();
        Assertions.assertThat((boolean)names.contains("org.drools.testcoverage.common.model")).isTrue();
        KiePackage kiePackage = (KiePackage)pkgs.toArray()[names.indexOf("org.drools.testcoverage.functional")];
        Assertions.assertThat((int)kiePackage.getRules().size()).isEqualTo(3);
    }

    @Test
    public void testXLSXComparingDates() {
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, sampleDateXLSXDecisionTable);
        KieSession ksession = kbase.newKieSession();
        InputObject inputObject1 = new InputObject();
        inputObject1.setDate(new Date());
        ksession.insert((Object)inputObject1);
        InputObject inputObject2 = new InputObject();
        inputObject2.setDate(new Date(0L));
        ksession.insert((Object)inputObject2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    public static class InputObject {
        private Date date;

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

