/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.event.DefaultRuleRuntimeEventListener;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class FactHandleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FactHandleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations(true);
    }

    @Test
    public void testFactHandleSequence() throws Exception {
        String drlString = "package org.jboss.brms\nimport " + Cheese.class.getCanonicalName() + ";\nrule \"FactHandleId\"\n    when\n        $c : Cheese()\n    then\n        // do something;\nend";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl("test", this.kieBaseTestConfiguration, drlString);
        ArrayList<Long> factHandleIDs = new ArrayList<Long>();
        KieSession kieSession = kBase.newKieSession();
        kieSession.addEventListener((RuleRuntimeEventListener)this.createCollectEventListener(factHandleIDs));
        kieSession.insert((Object)new Cheese("mozzarella"));
        kieSession.insert((Object)new Cheese("pecorino"));
        kieSession.fireAllRules();
        kieSession.dispose();
        kieSession = kBase.newKieSession();
        kieSession.addEventListener((RuleRuntimeEventListener)this.createCollectEventListener(factHandleIDs));
        kieSession.insert((Object)new Cheese("parmigiano"));
        kieSession.fireAllRules();
        Assertions.assertThat(factHandleIDs).containsExactly((Object[])new Long[]{1L, 2L, 1L});
    }

    private DefaultRuleRuntimeEventListener createCollectEventListener(final List<Long> factHandleIDs) {
        return new DefaultRuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                InternalFactHandle ifh = (InternalFactHandle)event.getFactHandle();
                factHandleIDs.add(ifh.getId());
            }
        };
    }
}

