/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.testcoverage.common.util.KieBaseModelProvider;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;

public enum KieBaseTestConfiguration implements KieBaseModelProvider
{
    CLOUD_IDENTITY{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_FROM_DRL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_IDENTITY_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_IDENTITY_MODEL_FLOW{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_DSL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_IDENTITY_MODEL_FLOW_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_IDENTITY_MODEL_PATTERN{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_DSL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_FROM_DRL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY_MODEL_FLOW{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_DSL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY_MODEL_FLOW_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY_MODEL_PATTERN{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_DSL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    CLOUD_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return false;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_FROM_DRL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY_MODEL_FLOW{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_DSL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY_MODEL_FLOW_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY_MODEL_PATTERN{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_DSL;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_FROM_DRL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.STANDARD_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY_MODEL_FLOW{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_DSL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY_MODEL_FLOW_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.FLOW_DSL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY_MODEL_PATTERN{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_DSL;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    }
    ,
    STREAM_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK{

        @Override
        public KieBaseModelProvider.RunType runType() {
            return KieBaseModelProvider.RunType.PATTERN_WITH_ALPHA_NETWORK;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isStreamMode() {
            return true;
        }

        @Override
        public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
            KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KieBaseTestConfiguration.KIE_BASE_MODEL_NAME);
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
            kieBaseModel.setDefault(true);
            return kieBaseModel;
        }

        @Override
        public KieBaseConfiguration getKieBaseConfiguration() {
            KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
            additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
            return kieBaseConfiguration;
        }
    };

    public static final String KIE_BASE_MODEL_NAME = "KieBaseModelName";
    private static List<KieBaseOption> additionalKieBaseOptions;

    @Override
    public void setAdditionalKieBaseOptions(KieBaseOption ... options) {
        additionalKieBaseOptions = Arrays.asList(options);
    }

    static {
        additionalKieBaseOptions = Collections.emptyList();
    }
}

