/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.parser;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.testcoverage.functional.parser.ParserTest;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;

public class DslParserTest
extends ParserTest {
    private final File dsl;

    public DslParserTest(File dslr, File dsl, KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(dslr, kieBaseTestConfiguration);
        this.dsl = dsl;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        HashSet<Object[]> set = new HashSet<Object[]>();
        for (File f : DslParserTest.getFiles("dsl", "dslr")) {
            String dslPath = f.getAbsolutePath();
            File dsl = new File(dslPath.substring(0, dslPath.length() - 1));
            set.add(new Object[]{dsl, f, KieBaseTestConfiguration.CLOUD_EQUALITY});
            if (TestParametersUtil.TEST_EXECUTABLE_MODEL_WITH_FLOW_DSL) {
                set.add(new Object[]{dsl, f, KieBaseTestConfiguration.CLOUD_EQUALITY_MODEL_FLOW});
            }
            if (!TestParametersUtil.TEST_EXECUTABLE_MODEL_WITH_PATTERN_DSL) continue;
            set.add(new Object[]{dsl, f, KieBaseTestConfiguration.CLOUD_EQUALITY_MODEL_PATTERN});
        }
        return set;
    }

    @Test
    public void testParserDsl() {
        Resource dslResource = KieServices.Factory.get().getResources().newFileSystemResource(this.dsl);
        Resource dslrResource = KieServices.Factory.get().getResources().newFileSystemResource(this.file);
        KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, dslResource, dslrResource);
    }

    @Test
    public void testParserDsl2() {
        Resource dslResource = KieServices.Factory.get().getResources().newFileSystemResource(this.dsl);
        Resource dslrResource = KieServices.Factory.get().getResources().newFileSystemResource(this.file);
        KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, true, dslrResource, dslResource);
    }
}

