/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.definition.type.Position;

@RunWith(value=Parameterized.class)
public class POJOAnnotationMergeTest {
    private static final String EVENT_CLASS_NAME = PositionAnnotatedEvent.class.getCanonicalName();
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String DRL = "package org.test\ndeclare " + EVENT_CLASS_NAME + "\n    @role(event)\nend \nrule 'sample rule' \nwhen \n  " + EVENT_CLASS_NAME + "( 'value1', 'value2'; )\nthen\nend\n";

    public POJOAnnotationMergeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testPositionFromPOJOIgnored() {
        KieUtil.getKieBuilderFromDrls(this.kieBaseTestConfiguration, true, DRL);
    }

    public static class PositionAnnotatedEvent {
        @Position(value=1)
        private String arg1;
        @Position(value=0)
        private String arg0;

        public String getArg1() {
            return this.arg1;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public String getArg0() {
            return this.arg0;
        }

        public void setArg0(String arg0) {
            this.arg0 = arg0;
        }
    }
}

