/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

public class NotInFusionTest
extends KieSessionTest {
    private static final String DRL_FILE = "JBRULES-3075.drl";
    private static final String RULE1 = "not equal";
    private static final String RULE2 = "not equal 2";
    private static final String RULE3 = "different";

    public NotInFusionTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getStreamKieBaseAndStatefulKieSessionConfigurations();
    }

    @Test
    public void testNoEvent() {
        KieSession ksession = this.session.getStateful();
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isTrue();
    }

    @Test
    public void testInsertFirst() throws Exception {
        KieSession ksession = this.session.getStateful();
        this.insertNotEvent(ksession);
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isFalse();
    }

    @Test
    public void testInsertFirstAndAdd() throws Exception {
        KieSession ksession = this.session.getStateful();
        this.insertNotEvent(ksession);
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isFalse();
        this.insertEvent(ksession);
        this.insertEvent(ksession);
        this.insertEvent(ksession);
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isTrue();
    }

    @Test
    public void testInsertFirstAndAdd2() throws Exception {
        KieSession ksession = this.session.getStateful();
        this.insertNotEvent(ksession);
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isFalse();
        for (int i = 0; i < 3; ++i) {
            this.insertNotEvent(ksession, "different value");
        }
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isTrue();
    }

    @Test
    public void testInsertFirstAndAdd3() throws Exception {
        KieSession ksession = this.session.getStateful();
        this.insertNotEvent(ksession);
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE3)).as(RULE3, new Object[0])).isFalse();
        for (int i = 0; i < 4; ++i) {
            this.insertNotEvent(ksession, "different value");
            ksession.fireAllRules();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE3)).as(RULE3, new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE1)).as(RULE1, new Object[0])).isTrue();
    }

    @Test
    public void testNoEntryPoint() throws Exception {
        KieSession ksession = this.session.getStateful();
        ksession.insert(this.createNotEvent(ksession, "value"));
        ksession.fireAllRules();
        Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE2)).isFalse();
        for (int i = 0; i < 3; ++i) {
            ksession.insert(this.createNotEvent(ksession, "different value"));
        }
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.firedRules.isRuleFired(RULE2)).as(RULE2, new Object[0])).isTrue();
    }

    private void insertNotEvent(KieSession ksession) throws Exception {
        this.insertNotEvent(ksession, "value");
    }

    private void insertNotEvent(KieSession ksession, String property) throws Exception {
        ksession.getEntryPoint("entryPoint").insert(this.createNotEvent(ksession, property));
    }

    private Object createNotEvent(KieSession ksession, String property) throws Exception {
        FactType type = ksession.getKieBase().getFactType("org.drools.testcoverage.regression", "NotEvent");
        Object instance = type.newInstance();
        type.set(instance, "property", (Object)property);
        return instance;
    }

    private void insertEvent(KieSession ksession) throws Exception {
        ksession.getEntryPoint("entryPoint").insert(this.createEvent(ksession));
    }

    private Object createEvent(KieSession ksession) throws Exception {
        FactType type = ksession.getKieBase().getFactType("org.drools.testcoverage.regression", "Event");
        Object instance = type.newInstance();
        type.set(instance, "property", (Object)"some value");
        return instance;
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL_FILE, NotInFusionTest.class);
    }
}

