/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.builder.DecisionTableInputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MultipleSheetsLoadingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleSheetsLoadingTest.class);
    private static final String XLS_EXTENSION = "xls";
    private static final String XLS_FILE_NAME_NO_EXTENSION = "multiple-sheets";
    private static final String XLS_FILE_NAME = "multiple-sheets.xls";
    private static final String WORKSHEET_1_NAME = "first";
    private static final String WORKSHEET_2_NAME = "second";

    public MultipleSheetsLoadingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void test() {
        KieBuilder kbuilder = this.buildResources();
        List results = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR, Message.Level.WARNING});
        if (results.size() > 0) {
            LOGGER.error(results.toString());
        }
        ((IterableAssert)Assertions.assertThat((Iterable)results).as("Some errors/warnings found", new Object[0])).isEmpty();
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder(kbuilder);
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        HashSet resultSet = new HashSet();
        ksession.execute(resultSet);
        ((AbstractIntegerAssert)Assertions.assertThat((int)resultSet.size()).as("Wrong number of rules was fired", new Object[0])).isEqualTo(2);
        for (String ruleName : new String[]{"rule1", "rule2"}) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)resultSet.contains(ruleName)).as("Rule " + ruleName + " was not fired!", new Object[0])).isTrue();
        }
    }

    private KieBuilder buildResources() {
        Resource resourceXlsFirst = this.createResourceWithConfig(WORKSHEET_1_NAME);
        Resource resourceXlsSecond = this.createResourceWithConfig(WORKSHEET_2_NAME);
        return KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, false, resourceXlsFirst, resourceXlsSecond);
    }

    private Resource createResourceWithConfig(String worksheetName) {
        Resource resourceXls = KieServices.Factory.get().getResources().newClassPathResource(XLS_FILE_NAME, this.getClass());
        resourceXls.setTargetPath(String.format("%s-%s.%s", XLS_FILE_NAME_NO_EXTENSION, worksheetName, XLS_EXTENSION));
        resourceXls.setConfiguration(this.createXLSResourceConfig(worksheetName));
        return resourceXls;
    }

    private ResourceConfiguration createXLSResourceConfig(String worksheetName) {
        DecisionTableConfigurationImpl resourceConfig = new DecisionTableConfigurationImpl();
        resourceConfig.setInputType(DecisionTableInputType.XLS);
        resourceConfig.setWorksheetName(worksheetName);
        return resourceConfig;
    }
}

