/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.KieSessionTest;
import org.drools.testcoverage.common.model.ListHolder;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleSalienceUpdateFactTest
extends KieSessionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleSalienceUpdateFactTest.class);
    private static final String DRL_FILE = "BRMS-580.drl";

    public MultipleSalienceUpdateFactTest(KieBaseTestConfiguration kieBaseTestConfiguration, KieSessionTestConfiguration kieSessionTestConfiguration) {
        super(kieBaseTestConfiguration, kieSessionTestConfiguration);
    }

    @Parameterized.Parameters(name="{1} (from {0})")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseAndStatefulKieSessionConfigurations();
    }

    @Test
    public void test() {
        this.session.setGlobal("LOGGER", LOGGER);
        ArrayList<Command> commands = new ArrayList<Command>();
        Person person = new Person("PAUL");
        ListHolder listHolder = new ListHolder();
        List<String> list = Arrays.asList("eins", "zwei", "drei");
        listHolder.setList(list);
        commands.add(KieUtil.getCommands().newInsert((Object)person));
        commands.add(KieUtil.getCommands().newInsert((Object)listHolder));
        commands.add(KieUtil.getCommands().newFireAllRules());
        this.session.execute(KieUtil.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)this.firedRules.isRuleFired("PERSON_PAUL")).isTrue();
        Assertions.assertThat((boolean)this.firedRules.isRuleFired("PERSON_PETER")).isTrue();
    }

    @Override
    protected Resource[] createResources() {
        return KieUtil.createResources(DRL_FILE, MultipleSalienceUpdateFactTest.class);
    }
}

