/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class AbstractCompositeRestrictionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractCompositeRestrictionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void test() {
        KieBuilder builder = KieUtil.getKieBuilderFromResources(this.kieBaseTestConfiguration, false, KieServices.Factory.get().getResources().newClassPathResource("abstractCompositeRestrictionTest.drl", this.getClass()));
        List msgs = builder.getResults().getMessages();
        String[] lines = ((Message)msgs.get(0)).getText().split("\n");
        String unable = "Unable to Analyse Expression valueType == Field.INT || valueType == Field.DOUBLE:";
        Assertions.assertThat((String)lines[0]).isEqualTo("Unable to Analyse Expression valueType == Field.INT || valueType == Field.DOUBLE:");
    }
}

