/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final int BUILD_PROPS_SEARCH_PARENT_DIR_LIMIT = 2;
    private static Properties properties;
    private static File basedir;

    private PropertiesUtil() {
    }

    public static synchronized File getBasedir() {
        if (basedir == null) {
            String basedirProp = System.getProperty("basedir");
            ((AbstractStringAssert)Assertions.assertThat((String)basedirProp).as("System property for basedir not set!", new Object[0])).isNotNull();
            basedir = new File(basedirProp);
            Assert.assertTrue((String)("Basedir " + basedir.getAbsolutePath() + " does not exist! Check value of 'basedir' system property."), (boolean)basedir.exists());
        }
        return basedir;
    }

    public static synchronized File getTempDir() {
        File tempDir;
        try {
            tempDir = new File(PropertiesUtil.getBasedir(), PropertiesUtil.getProperty("temp.dir", "target/tmp"));
        }
        catch (Exception ex) {
            LOGGER.error("Error occured when attempting to retrieve the 'temp.dir' property", (Throwable)ex);
            tempDir = new File(System.getProperty("java.io.tmpdir"), "brms-tests");
        }
        if (!tempDir.exists() && !tempDir.mkdir()) {
            throw new IllegalStateException("Cannot create temp.dir at '" + tempDir.getAbsolutePath() + "'!");
        }
        return tempDir;
    }

    public static synchronized File getLogDir() {
        return new File(PropertiesUtil.getBasedir(), PropertiesUtil.getProperty("log.dir", "target/log"));
    }

    public static String getProperty(String key) {
        return PropertiesUtil.getProperties().getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return PropertiesUtil.getProperties().getProperty(key, defaultValue);
        }
        catch (Exception ex) {
            LOGGER.error("Error occured when attempting to retrieve the '" + key + "' property", (Throwable)ex);
            return defaultValue;
        }
    }

    public static synchronized Properties getProperties() {
        return properties == null ? PropertiesUtil.createProperties() : (Properties)properties.clone();
    }

    private static synchronized Properties createProperties() {
        File propFile = PropertiesUtil.getPropertiesFile(PropertiesUtil.getBasedir().getAbsoluteFile(), 2);
        Assert.assertTrue((String)("Couldn't find build.properties at " + propFile.getAbsolutePath()), (boolean)propFile.exists());
        properties = new Properties();
        try (FileInputStream fis = new FileInputStream(propFile);){
            properties.load(fis);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Properties file not found. At this point, this is impossible.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Properties file cannot be read!", e);
        }
        return (Properties)properties.clone();
    }

    private static File getPropertiesFile(File dir, int parentDirLimit) {
        LOGGER.debug("Searching for 'build.properties', parent search limit is {}.", (Object)parentDirLimit);
        Assert.assertTrue((String)"build.properties file not found before reaching the limit for searching parent directories.", (parentDirLimit >= 0 && dir != null ? 1 : 0) != 0);
        LOGGER.debug("- searching dir: {}", (Object)dir.getAbsolutePath());
        File propFile = new File(dir, "build.properties");
        if (!propFile.exists()) {
            return PropertiesUtil.getPropertiesFile(dir.getParentFile(), parentDirLimit - 1);
        }
        return propFile;
    }
}

