/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.testcoverage.common.util.KieBaseModelProvider;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;

public enum KieBaseTestConfiguration implements KieBaseModelProvider
{
    CLOUD_IDENTITY(true, false, false),
    CLOUD_IDENTITY_ALPHA_NETWORK(true, false, true),
    CLOUD_IDENTITY_MODEL_PATTERN(true, false, false, ExecutableModelProject.class),
    CLOUD_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK(true, false, true, ExecutableModelProject.class),
    CLOUD_EQUALITY(false, false, false),
    CLOUD_EQUALITY_ALPHA_NETWORK(false, false, true),
    CLOUD_EQUALITY_MODEL_PATTERN(false, false, false, ExecutableModelProject.class),
    CLOUD_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK(false, false, true, ExecutableModelProject.class),
    STREAM_IDENTITY(true, true, false),
    STREAM_IDENTITY_ALPHA_NETWORK(true, true, true),
    STREAM_IDENTITY_MODEL_PATTERN(true, true, false, ExecutableModelProject.class),
    STREAM_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK(true, true, true, ExecutableModelProject.class),
    STREAM_EQUALITY(false, true, false),
    STREAM_EQUALITY_ALPHA_NETWORK(false, true, true),
    STREAM_EQUALITY_MODEL_PATTERN(false, true, false, ExecutableModelProject.class),
    STREAM_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK(false, true, true, ExecutableModelProject.class);

    public static final String KIE_BASE_MODEL_NAME = "KieBaseModelName";
    private static List<KieBaseOption> additionalKieBaseOptions;
    private boolean identity;
    private boolean streamMode;
    private final boolean alphaNetworkCompiler;
    private final Class<? extends KieBuilder.ProjectType> executableModelProjectClass;

    private KieBaseTestConfiguration(boolean identity, boolean streamMode, boolean alphaNetworkCompiler) {
        this(identity, streamMode, alphaNetworkCompiler, null);
    }

    private KieBaseTestConfiguration(boolean identity, boolean streamMode, boolean alphaNetworkCompiler, Class<? extends KieBuilder.ProjectType> executableModelProjectClass) {
        this.identity = identity;
        this.streamMode = streamMode;
        this.alphaNetworkCompiler = alphaNetworkCompiler;
        this.executableModelProjectClass = executableModelProjectClass;
    }

    @Override
    public void setAdditionalKieBaseOptions(KieBaseOption ... options) {
        additionalKieBaseOptions = Arrays.asList(options);
    }

    @Override
    public boolean isIdentity() {
        return this.identity;
    }

    @Override
    public boolean isStreamMode() {
        return this.streamMode;
    }

    @Override
    public boolean useAlphaNetworkCompiler() {
        return this.alphaNetworkCompiler;
    }

    @Override
    public Optional<Class<? extends KieBuilder.ProjectType>> getExecutableModelProjectClass() {
        return Optional.ofNullable(this.executableModelProjectClass);
    }

    public boolean isExecutableModel() {
        return this.executableModelProjectClass != null;
    }

    @Override
    public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
        KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KIE_BASE_MODEL_NAME);
        if (this.isStreamMode()) {
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
        } else {
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
        }
        if (this.isIdentity()) {
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
        } else {
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
        }
        kieBaseModel.setDefault(true);
        return kieBaseModel;
    }

    @Override
    public KieBaseConfiguration getKieBaseConfiguration() {
        KieBaseConfiguration kieBaseConfiguration = RuleBaseFactory.newKnowledgeBaseConfiguration();
        if (this.isStreamMode()) {
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
        } else {
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
        }
        if (this.isIdentity()) {
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
        } else {
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        }
        additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
        return kieBaseConfiguration;
    }

    static {
        additionalKieBaseOptions = Collections.emptyList();
    }
}

