/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import org.assertj.core.api.SoftAssertions;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class EventFactHandleDeserializationTest {
    @Test
    public void testDisconnectedEventFactHandle() {
        String drl = "declare String \n  @role(event)\nend\n";
        KieSession ksession = new KieHelper().addContent("declare String \n  @role(event)\nend\n", ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        DefaultFactHandle helloHandle = (DefaultFactHandle)ksession.insert((Object)"hello");
        DefaultFactHandle goodbyeHandle = (DefaultFactHandle)ksession.insert((Object)"goodbye");
        SoftAssertions softly = new SoftAssertions();
        DefaultFactHandle key = DefaultFactHandle.createFromExternalFormat((String)helloHandle.toExternalForm());
        softly.assertThat((Object)key).isInstanceOf(EventFactHandle.class);
        softly.assertThat(ksession.getObject((FactHandle)key)).isEqualTo((Object)"hello");
        key = DefaultFactHandle.createFromExternalFormat((String)goodbyeHandle.toExternalForm());
        softly.assertThat((Object)key).isInstanceOf(EventFactHandle.class);
        softly.assertThat(ksession.getObject((FactHandle)key)).isEqualTo((Object)"goodbye");
        softly.assertAll();
    }
}

