/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.testcoverage.common.util.KieBaseModelProvider;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;

public enum KieBaseTestConfiguration implements KieBaseModelProvider
{
    CLOUD_IDENTITY(1),
    CLOUD_IDENTITY_ALPHA_NETWORK(5),
    CLOUD_IDENTITY_MODEL_PATTERN(1, ExecutableModelProject.class),
    CLOUD_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK(5, ExecutableModelProject.class),
    CLOUD_EQUALITY(0),
    CLOUD_EQUALITY_ALPHA_NETWORK(4),
    CLOUD_EQUALITY_MODEL_PATTERN(0, ExecutableModelProject.class),
    CLOUD_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK(4, ExecutableModelProject.class),
    STREAM_IDENTITY(3),
    STREAM_IDENTITY_ALPHA_NETWORK(7),
    STREAM_IDENTITY_MODEL_PATTERN(3, ExecutableModelProject.class),
    STREAM_IDENTITY_MODEL_PATTERN_ALPHA_NETWORK(7, ExecutableModelProject.class),
    STREAM_EQUALITY(2),
    STREAM_EQUALITY_ALPHA_NETWORK(6),
    STREAM_EQUALITY_MODEL_PATTERN(2, ExecutableModelProject.class),
    STREAM_EQUALITY_MODEL_PATTERN_ALPHA_NETWORK(6, ExecutableModelProject.class),
    CLOUD_IDENTITY_IMMUTABLE(9),
    CLOUD_IDENTITY_IMMUTABLE_MODEL_PATTERN(9, ExecutableModelProject.class);

    public static final String KIE_BASE_MODEL_NAME = "KieBaseModelName";
    private static List<KieBaseOption> additionalKieBaseOptions;
    private final int options;
    private final Class<? extends KieBuilder.ProjectType> executableModelProjectClass;

    private KieBaseTestConfiguration(int options) {
        this(options, null);
    }

    private KieBaseTestConfiguration(int options, Class<? extends KieBuilder.ProjectType> executableModelProjectClass) {
        this.options = options;
        this.executableModelProjectClass = executableModelProjectClass;
    }

    @Override
    public void setAdditionalKieBaseOptions(KieBaseOption ... options) {
        additionalKieBaseOptions = Arrays.asList(options);
    }

    @Override
    public boolean isIdentity() {
        return (this.options & 1) != 0;
    }

    @Override
    public boolean isStreamMode() {
        return (this.options & 2) != 0;
    }

    @Override
    public boolean useAlphaNetworkCompiler() {
        return (this.options & 4) != 0;
    }

    @Override
    public boolean isImmutable() {
        return (this.options & 8) != 0;
    }

    @Override
    public Optional<Class<? extends KieBuilder.ProjectType>> getExecutableModelProjectClass() {
        return Optional.ofNullable(this.executableModelProjectClass);
    }

    public boolean isExecutableModel() {
        return this.executableModelProjectClass != null;
    }

    @Override
    public KieBaseModel getKieBaseModel(KieModuleModel kieModuleModel) {
        KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel(KIE_BASE_MODEL_NAME);
        if (this.isStreamMode()) {
            kieBaseModel.setEventProcessingMode(EventProcessingOption.STREAM);
        } else {
            kieBaseModel.setEventProcessingMode(EventProcessingOption.CLOUD);
        }
        if (this.isIdentity()) {
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.IDENTITY);
        } else {
            kieBaseModel.setEqualsBehavior(EqualityBehaviorOption.EQUALITY);
        }
        if (this.isImmutable()) {
            kieBaseModel.setMutability(KieBaseMutabilityOption.DISABLED);
        } else {
            kieBaseModel.setMutability(KieBaseMutabilityOption.ALLOWED);
        }
        kieBaseModel.setDefault(true);
        return kieBaseModel;
    }

    @Override
    public KieBaseConfiguration getKieBaseConfiguration() {
        KieBaseConfiguration kieBaseConfiguration = RuleBaseFactory.newKnowledgeBaseConfiguration();
        if (this.isStreamMode()) {
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
        } else {
            kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.CLOUD);
        }
        if (this.isIdentity()) {
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
        } else {
            kieBaseConfiguration.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        }
        if (this.isImmutable()) {
            kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.DISABLED);
        } else {
            kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.ALLOWED);
        }
        additionalKieBaseOptions.forEach(arg_0 -> ((KieBaseConfiguration)kieBaseConfiguration).setOption(arg_0));
        return kieBaseConfiguration;
    }

    static {
        additionalKieBaseOptions = Collections.emptyList();
    }
}

