/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.ViewChangedEventListener;

@RunWith(value=Parameterized.class)
public class LiveQueriesBadResultTest {
    private ArrayList<Object> inserted;
    private ArrayList<Object> updated;
    private ArrayList<Object> deleted;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LiveQueriesBadResultTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Before
    public void initialize() {
        this.inserted = new ArrayList();
        this.updated = new ArrayList();
        this.deleted = new ArrayList();
    }

    @Ignore(value="TODO - check correct exception in this test when DROOLS-2186 is fixed.")
    @Test
    public void testCallingLiveQueryWithoutParametersButItHasParams() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("person"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("person"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("person"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr"));
        ksession.openLiveQuery("queryWithParams", new Object[0], listener);
    }

    @Test
    public void testAccessToNotExistingVariable() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("bad"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("bad"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("bad"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ksession.openLiveQuery("simple query with no parameters", new Object[0], listener)).isInstanceOf(RuntimeException.class)).hasMessage("The identifier 'bad' does not exist as a bound variable for this query");
    }

    @Ignore(value="TODO - check correct exception in this test when DROOLS-2187 is fixed.")
    @Test
    public void testOfBadParameters() {
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                LiveQueriesBadResultTest.this.updated.add(row.get("person"));
            }

            public void rowInserted(Row row) {
                LiveQueriesBadResultTest.this.inserted.add(row.get("person"));
            }

            public void rowDeleted(Row row) {
                LiveQueriesBadResultTest.this.deleted.add(row.get("person"));
            }
        };
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), this.kieBaseTestConfiguration, "query.drl");
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("Petr", 25));
        ksession.openLiveQuery("queryWithParamWithoutType", null, listener);
    }
}

