/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional.oopath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.InternationalAddress;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.ResourceUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.builder.DecisionTableInputType;

@RunWith(value=Parameterized.class)
public class OOPathDtablesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathDtablesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void xlsWithOOPathTest() {
        KieSession kieSession = this.getKieSessionFromXls("oopath.drl.xls");
        this.testOOPathWithDTable(kieSession);
    }

    @Test
    public void xlsxWithOOPathTest() {
        KieSession kieSession = this.getKieSessionFromXlsx("oopath.drl.xlsx");
        this.testOOPathWithDTable(kieSession);
    }

    @Test
    public void csvWithOOPathTest() {
        KieSession kieSession = this.getKieSessionFromCsv("oopath.drl.csv");
        this.testOOPathWithDTable(kieSession);
    }

    private void testOOPathWithDTable(KieSession kieSession) {
        ArrayList<String> list = new ArrayList<String>();
        this.populateKieSession(kieSession, list);
        int rulesFired = kieSession.fireAllRules();
        Assertions.assertThat((int)rulesFired).isEqualTo(2);
        this.verifyRuleFireResults(list);
        this.verifyQueryResults(kieSession.getQueryResults("listSafeCities", new Object[0]));
    }

    private KieSession getKieSessionFromCsv(String csvFile) {
        Resource resource = ResourceUtil.getDecisionTableResourceFromClasspath(csvFile, this.getClass(), DecisionTableInputType.CSV);
        return KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource).newKieSession();
    }

    private KieSession getKieSessionFromXls(String xlsFile) {
        return this.getKieSessionFromExcel(xlsFile, DecisionTableInputType.XLS);
    }

    private KieSession getKieSessionFromXlsx(String xlsxFile) {
        return this.getKieSessionFromExcel(xlsxFile, DecisionTableInputType.XLSX);
    }

    private KieSession getKieSessionFromExcel(String file, DecisionTableInputType fileType) {
        Resource resource = ResourceUtil.getDecisionTableResourceFromClasspath(file, this.getClass(), fileType);
        return KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource).newKieSession();
    }

    private void populateKieSession(KieSession kieSession, List<String> list) {
        Person[] persons;
        kieSession.setGlobal("list", list);
        for (Person p : persons = this.prepareData()) {
            kieSession.insert((Object)p);
        }
    }

    private Person[] prepareData() {
        Person bruno = new Person("Bruno", 25);
        bruno.setAddress(new InternationalAddress("Some Street", 10, "Nice City", "Safecountry"));
        Person robert = new Person("Robert", 17);
        robert.setAddress(new InternationalAddress("Some Street", 12, "Small City", "Riskyland"));
        Person joe = new Person("Joe", 11);
        joe.setAddress(new InternationalAddress("Some Street", 13, "Big City", "Safecountry"));
        Person mike = new Person("Mike", 25);
        mike.setAddress(new Address("Some Street", 14, "Local City"));
        return new Person[]{bruno, robert, joe, mike};
    }

    private void verifyQueryResults(QueryResults results) {
        Assertions.assertThat((Iterable)results).isNotEmpty();
        QueryResultsRow resultsRow = (QueryResultsRow)results.iterator().next();
        Assertions.assertThat((Object)resultsRow.get("$cities")).isInstanceOf(List.class);
        List cities = (List)resultsRow.get("$cities");
        Assertions.assertThat((List)cities).containsExactlyInAnyOrder((Object[])new String[]{"Nice City", "Big City"});
    }

    private void verifyRuleFireResults(List<String> list) {
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"SafeDriver", "Risky Driver"});
    }
}

