/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.MavenUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.scanner.KieMavenRepository;
import org.kie.test.testcategory.TurtleTestCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="DROOLS-3628 Ignoring, because it can be useful when run locally, however due to unpredictable GC behaviour, unstable in automation.")
@Category(value={TurtleTestCategory.class})
public class KieScannerMemoryTest {
    private static final Logger logger = LoggerFactory.getLogger(KieScannerMemoryTest.class);
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScannerMemoryFootprint() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        KieModule kieModule = KieUtil.getKieModuleFromDrls("org.drools.testcoverage.functional", KieBaseTestConfiguration.CLOUD_IDENTITY, "rule R when then end");
        ReleaseId releaseId = kieModule.getReleaseId();
        repository.installArtifact(releaseId, (InternalKieModule)kieModule, MavenUtil.createPomXml(this.fileManager, releaseId, new ReleaseId[0]));
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieScanner kieScanner = kieServices.newKieScanner(kieContainer);
        kieScanner.start(20L);
        try {
            this.measureMemoryFootprint(1000, 100, 6, 30L);
        }
        finally {
            kieScanner.stop();
        }
    }

    private void measureMemoryFootprint(int numberOfIterations, int numberOfAveragedIterations, int acceptedNumberOfMemoryRaises, long waitEachIterationMillis) {
        long lastTimeInMillis = System.currentTimeMillis();
        Runtime runtime = Runtime.getRuntime();
        int memoryRaiseCount = 0;
        long averageMemory = 0L;
        ArrayList<Long> averageMemoryFootprints = new ArrayList<Long>();
        for (int i = 1; i < numberOfIterations; ++i) {
            this.waitForMillis(waitEachIterationMillis, lastTimeInMillis);
            lastTimeInMillis = System.currentTimeMillis();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            averageMemory += usedMemory;
            if (i % numberOfAveragedIterations != 0) continue;
            averageMemory /= (long)numberOfAveragedIterations;
            if (averageMemoryFootprints.size() > 0) {
                long previousAverageMemory = (Long)averageMemoryFootprints.get(averageMemoryFootprints.size() - 1);
                memoryRaiseCount = averageMemory > previousAverageMemory ? ++memoryRaiseCount : 0;
                ((AbstractBooleanAssert)Assertions.assertThat((memoryRaiseCount > acceptedNumberOfMemoryRaises ? 1 : 0) != 0).as("Memory raised during " + (acceptedNumberOfMemoryRaises + 1) + " consecutive measurements, there is probably some memory leak! " + this.getMemoryMeasurementsString(averageMemoryFootprints), new Object[0])).isFalse();
            }
            logger.debug("Average memory: " + averageMemory);
            averageMemoryFootprints.add(averageMemory);
            averageMemory = 0L;
        }
    }

    private void waitForMillis(long millis, long startTimeMillis) {
        while (System.currentTimeMillis() - startTimeMillis < millis) {
        }
    }

    private String getMemoryMeasurementsString(List<Long> memoryMeasurements) {
        StringBuilder builder = new StringBuilder();
        builder.append("Measured used memory: ");
        for (int i = 1; i <= memoryMeasurements.size(); ++i) {
            long measurement = memoryMeasurements.get(i - 1) / 1024L / 1024L;
            builder.append(i + ": " + measurement + " MB; ");
        }
        return builder.toString();
    }
}

