/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.common.util;

import org.drools.core.ClockType;
import org.drools.testcoverage.common.util.KieSessionModelProvider;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.Option;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;

public enum KieSessionTestConfiguration implements KieSessionModelProvider
{
    STATEFUL_REALTIME(true, false),
    STATEFUL_PSEUDO(true, true),
    STATELESS_REALTIME(false, false);

    public static final String KIE_SESSION_MODEL_NAME = "KieSessionModelName";
    private final boolean stateful;
    private final boolean pseudoClock;

    public boolean isStateful() {
        return this.stateful;
    }

    private KieSessionTestConfiguration(boolean stateful) {
        this.stateful = stateful;
        this.pseudoClock = false;
    }

    private KieSessionTestConfiguration(boolean stateful, boolean pseudoClock) {
        this.stateful = stateful;
        this.pseudoClock = pseudoClock;
    }

    @Override
    public KieSessionModel getKieSessionModel(KieBaseModel kieBaseModel) {
        KieSessionModel kieSessionModel = kieBaseModel.newKieSessionModel(KIE_SESSION_MODEL_NAME);
        if (this.stateful) {
            kieSessionModel.setType(KieSessionModel.KieSessionType.STATEFUL);
        } else {
            kieSessionModel.setType(KieSessionModel.KieSessionType.STATELESS);
        }
        if (this.pseudoClock) {
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.toString()));
        } else {
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
        }
        kieSessionModel.setDefault(true);
        return kieSessionModel;
    }

    @Override
    public KieSessionConfiguration getKieSessionConfiguration() {
        KieSessionConfiguration kieSessionConfiguration = KieServices.Factory.get().newKieSessionConfiguration();
        if (this.pseudoClock) {
            kieSessionConfiguration.setOption((Option)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.toString()));
        } else {
            kieSessionConfiguration.setOption((Option)ClockTypeOption.get((String)ClockType.REALTIME_CLOCK.toString()));
        }
        return kieSessionConfiguration;
    }
}

