/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.functional;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.ResourceUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class UnicodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public UnicodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations();
    }

    @Test
    public void testJapanese() {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newClassPathResource("unicode.drl", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList \u4e00\u89a7 = new ArrayList();
        commands.add(kieServices.getCommands().newSetGlobal("\u4e00\u89a7", \u4e00\u89a7));
        \u4eba \u6a2a\u7db1 = new \u4eba();
        \u6a2a\u7db1.set\u6b73(30);
        \u6a2a\u7db1.set\u306e\u540d\u524d("\u6a2a\u7db1");
        \u6a2a\u7db1.set\u65e2\u5a5a(true);
        commands.add(kieServices.getCommands().newInsert((Object)\u6a2a\u7db1));
        commands.add(kieServices.getCommands().newFireAllRules("firedRulesCount"));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((Object)results.getValue("firedRulesCount")).isEqualTo((Object)2);
        Assertions.assertThat((int)\u4e00\u89a7.size()).isEqualTo(1);
        Assertions.assertThat((String)((\u4eba)\u4e00\u89a7.iterator().next()).get\u306e\u540d\u524d()).isEqualTo("\u6a2a\u7db1");
    }

    @Test
    public void testCzech() {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newClassPathResource("unicode.drl", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList lid\u00e9 = new ArrayList();
        commands.add(kieServices.getCommands().newSetGlobal("lid\u00e9", lid\u00e9));
        \u010clov\u011bk \u0158eho\u0159 = new \u010clov\u011bk();
        \u0158eho\u0159.setV\u011bk(30);
        \u0158eho\u0159.setJm\u00e9no("\u0158eho\u0159");
        commands.add(kieServices.getCommands().newInsert((Object)\u0158eho\u0159));
        commands.add(kieServices.getCommands().newFireAllRules());
        ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((Object)kbase.getRule("org.drools.testcoverage.functional", "p\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy")).isNotNull();
        Map metaData = kbase.getRule("org.drools.testcoverage.functional", "p\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy").getMetaData();
        Assertions.assertThat(metaData.get("Pr\u00e1vn\u00edPo\u017eadavek")).isEqualTo((Object)"Osoba star\u0161\u00ed osmn\u00e1cti let");
        Assertions.assertThat((int)lid\u00e9.size()).isEqualTo(2);
        Assertions.assertThat((String)((\u010clov\u011bk)lid\u00e9.get(0)).getJm\u00e9no()).isEqualTo("\u0158eho\u0159");
        Assertions.assertThat((String)((\u010clov\u011bk)lid\u00e9.get(1)).getJm\u00e9no()).isEqualTo("Old\u0159i\u0161ka");
    }

    @Test
    public void testCzechDomainSpecificLanguage() {
        KieServices kieServices = KieServices.Factory.get();
        Resource dsl = kieServices.getResources().newClassPathResource("unicode.dsl", this.getClass());
        Resource dslr = kieServices.getResources().newClassPathResource("unicode.dslr", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, dsl, dslr);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList dosp\u011bl\u00ed = new ArrayList();
        commands.add(kieServices.getCommands().newSetGlobal("dosp\u011bl\u00ed", dosp\u011bl\u00ed));
        \u010clov\u011bk \u0158eho\u0159 = new \u010clov\u011bk();
        \u0158eho\u0159.setV\u011bk(30);
        \u0158eho\u0159.setJm\u00e9no("\u0158eho\u0159");
        commands.add(kieServices.getCommands().newInsert((Object)\u0158eho\u0159));
        commands.add(kieServices.getCommands().newFireAllRules());
        ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((Object)kbase.getRule("org.drools.testcoverage.functional", "pokusn\u00e9 dom\u00e9nov\u011b specifick\u00e9 pravidlo")).isNotNull();
        Assertions.assertThat((int)dosp\u011bl\u00ed.size()).isEqualTo(1);
        Assertions.assertThat((String)((\u010clov\u011bk)dosp\u011bl\u00ed.iterator().next()).getJm\u00e9no()).isEqualTo("\u0158eho\u0159");
    }

    @Test
    public void testCzechXLSDecisionTable() throws FileNotFoundException {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newClassPathResource("unicode.drl.xls", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList dosp\u011bl\u00ed = new ArrayList();
        commands.add(kieServices.getCommands().newSetGlobal("dosp\u011bl\u00ed", dosp\u011bl\u00ed));
        \u010clov\u011bk \u0158eho\u0159 = new \u010clov\u011bk();
        \u0158eho\u0159.setV\u011bk(30);
        \u0158eho\u0159.setJm\u00e9no("\u0158eho\u0159");
        commands.add(kieServices.getCommands().newInsert((Object)\u0158eho\u0159));
        commands.add(kieServices.getCommands().newFireAllRules());
        ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((Object)kbase.getRule("org.drools.testcoverage.functional", "p\u0159idej k dosp\u011bl\u00fdm")).isNotNull();
        Assertions.assertThat((int)dosp\u011bl\u00ed.size()).isEqualTo(1);
        Assertions.assertThat((String)((\u010clov\u011bk)dosp\u011bl\u00ed.iterator().next()).getJm\u00e9no()).isEqualTo("\u0158eho\u0159");
    }

    @Test
    public void testCzechCSVDecisionTable() throws FileNotFoundException {
        KieServices kieServices = KieServices.Factory.get();
        Resource decisionTable = ResourceUtil.getDecisionTableResourceFromClasspath("unicode.drl.csv", this.getClass(), DecisionTableInputType.CSV);
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, decisionTable);
        KieSession ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList dosp\u011bl\u00ed = new ArrayList();
        commands.add(kieServices.getCommands().newSetGlobal("dosp\u011bl\u00ed", dosp\u011bl\u00ed));
        \u010clov\u011bk \u0158eho\u0159 = new \u010clov\u011bk();
        \u0158eho\u0159.setV\u011bk(30);
        \u0158eho\u0159.setJm\u00e9no("\u0158eho\u0159");
        commands.add(kieServices.getCommands().newInsert((Object)\u0158eho\u0159));
        commands.add(kieServices.getCommands().newFireAllRules());
        ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((Object)kbase.getRule("org.drools.testcoverage.functional", "pokusn\u00e9 pravidlo rozhodovac\u00ed tabulky")).isNotNull();
        Assertions.assertThat((int)dosp\u011bl\u00ed.size()).isEqualTo(1);
        Assertions.assertThat((String)((\u010clov\u011bk)dosp\u011bl\u00ed.iterator().next()).getJm\u00e9no()).isEqualTo("\u0158eho\u0159");
    }

    @Test
    public void testQueryCallFromJava() throws InstantiationException, IllegalAccessException {
        KieServices kieServices = KieServices.Factory.get();
        Resource resource = kieServices.getResources().newClassPathResource("unicode.drl", this.getClass());
        KieBase kbase = KieBaseUtil.getKieBaseFromResources(this.kieBaseTestConfiguration, resource);
        KieSession ksession = kbase.newKieSession();
        FactType locationType = kbase.getFactType("org.drools.testcoverage.functional", "Um\u00edst\u011bn\u00ed");
        Object hru\u0161ka = locationType.newInstance();
        locationType.set(hru\u0161ka, "v\u011bc", (Object)"hru\u0161ka");
        locationType.set(hru\u0161ka, "m\u00edsto", (Object)"kuchyn\u011b");
        Object st\u016fl = locationType.newInstance();
        locationType.set(st\u016fl, "v\u011bc", (Object)"st\u016fl");
        locationType.set(st\u016fl, "m\u00edsto", (Object)"kancel\u00e1\u0159");
        Object sv\u00edtilna = locationType.newInstance();
        locationType.set(sv\u00edtilna, "v\u011bc", (Object)"sv\u00edtilna");
        locationType.set(sv\u00edtilna, "m\u00edsto", (Object)"st\u016fl");
        Object ob\u00e1lka = locationType.newInstance();
        locationType.set(ob\u00e1lka, "v\u011bc", (Object)"ob\u00e1lka");
        locationType.set(ob\u00e1lka, "m\u00edsto", (Object)"st\u016fl");
        Object kl\u00ed\u010d = locationType.newInstance();
        locationType.set(kl\u00ed\u010d, "v\u011bc", (Object)"kl\u00ed\u010d");
        locationType.set(kl\u00ed\u010d, "m\u00edsto", (Object)"ob\u00e1lka");
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(kieServices.getCommands().newInsert(hru\u0161ka));
        commands.add(kieServices.getCommands().newInsert(st\u016fl));
        commands.add(kieServices.getCommands().newInsert(sv\u00edtilna));
        commands.add(kieServices.getCommands().newInsert(ob\u00e1lka));
        commands.add(kieServices.getCommands().newInsert(kl\u00ed\u010d));
        String queryAlias = "obsa\u017eeno";
        commands.add(kieServices.getCommands().newQuery("obsa\u017eeno", "jeObsa\u017een", new Object[]{Variable.v, "kancel\u00e1\u0159"}));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)kieServices.getCommands().newBatchExecution(commands, null));
        QueryResults qResults = (QueryResults)results.getValue("obsa\u017eeno");
        ArrayList<String> l = new ArrayList<String>();
        for (QueryResultsRow r : qResults) {
            l.add((String)r.get("x"));
        }
        Assertions.assertThat((int)l.size()).isEqualTo(4);
        Assertions.assertThat((boolean)l.contains("st\u016fl")).isTrue();
        Assertions.assertThat((boolean)l.contains("sv\u00edtilna")).isTrue();
        Assertions.assertThat((boolean)l.contains("ob\u00e1lka")).isTrue();
        Assertions.assertThat((boolean)l.contains("kl\u00ed\u010d")).isTrue();
    }

    @Test
    public void testMutibyteJavaDialect() {
        String drl = "rule R dialect \"java\" when\n  \uff24: String( )\nthen\n  System.out.println( \uff24.toString() );\nend\n";
        KieSession kieSession = new KieHelper().addContent("rule R dialect \"java\" when\n  \uff24: String( )\nthen\n  System.out.println( \uff24.toString() );\nend\n", ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        kieSession.insert((Object)"Hello");
        int fired = kieSession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    public static class \u4eba {
        private int \u6b73;
        private String \u306e\u540d\u524d;
        private boolean \u65e2\u5a5a;

        public void set\u6b73(int \u6b73) {
            this.\u6b73 = \u6b73;
        }

        public int get\u6b73() {
            return this.\u6b73;
        }

        public void set\u306e\u540d\u524d(String \u306e\u540d\u524d) {
            this.\u306e\u540d\u524d = \u306e\u540d\u524d;
        }

        public String get\u306e\u540d\u524d() {
            return this.\u306e\u540d\u524d;
        }

        public boolean is\u65e2\u5a5a() {
            return this.\u65e2\u5a5a;
        }

        public void set\u65e2\u5a5a(boolean \u65e2\u5a5a) {
            this.\u65e2\u5a5a = \u65e2\u5a5a;
        }
    }

    public static class \u010clov\u011bk {
        private int v\u011bk;
        private String jm\u00e9no;

        public void setV\u011bk(int v\u011bk) {
            this.v\u011bk = v\u011bk;
        }

        public int getV\u011bk() {
            return this.v\u011bk;
        }

        public void setJm\u00e9no(String jm\u00e9no) {
            this.jm\u00e9no = jm\u00e9no;
        }

        public String getJm\u00e9no() {
            return this.jm\u00e9no;
        }
    }
}

