/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testcoverage.regression;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.compiler.Cheese;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class TruthMaintenanceSystemConcurrencyTest {
    @Test
    public void testUsingMultipleSessionsConcurrently() throws InterruptedException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_concurrency.drl", this.getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        Collection errors = Collections.synchronizedCollection(new LinkedList());
        for (int i = 0; i < 2000; ++i) {
            executorService.submit(() -> {
                try {
                    StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
                    ksession.fireAllRules();
                    Assertions.assertThat((Collection)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class))).hasSize(2);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            });
        }
        executorService.shutdown();
        Assertions.assertThat((boolean)executorService.awaitTermination(2L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat(errors).isEmpty();
    }
}

