/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.testcoverage.instrumentation.separate;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.integration.testcoverage.instrumentation.separate.TestUtil;
import org.kie.integration.testcoverage.instrumentation.separate.model.Dog;
import org.kie.integration.testcoverage.instrumentation.separate.model.Person;
import org.kie.integration.testcoverage.instrumentation.separate.model.Pet;

public class InstrumentationTest {
    private static final KieServices KIE_SERVICES = KieServices.get();
    private static final ReleaseId RELEASE_ID = KIE_SERVICES.newReleaseId("org.drools.testcoverage", "kjar-with-separate-instrumentation", TestUtil.getProjectVersion());
    private static KieContainer kieContainer;
    private KieSession kieSession;
    private List<String> results;

    @BeforeClass
    public static void loadKieContainer() {
        kieContainer = KIE_SERVICES.newKieContainer(RELEASE_ID);
    }

    @Before
    public void prepareSession() {
        this.kieSession = kieContainer.newKieSession();
        this.results = new ArrayList<String>();
        this.kieSession.setGlobal("results", this.results);
    }

    @After
    public void disposeSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.results = null;
    }

    @Test
    public void testLoadingKJarAndFiringRules() {
        String dogName = "Azor";
        Person person = new Person("Bruno", Integer.valueOf(17));
        person.addPet((Pet)new Dog("Azor", 2));
        this.kieSession.insert((Object)person);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Azor"});
    }

    @Test
    public void testOOPathReactivityWithInstrumentedModel() {
        Person person = new Person("Bruno", Integer.valueOf(17));
        FactHandle fh = this.kieSession.insert((Object)person);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).isEmpty();
        person.setAge(Integer.valueOf(18));
        this.kieSession.update(fh, (Object)person);
        this.kieSession.fireAllRules();
        Assertions.assertThat(this.results).containsExactlyInAnyOrder((Object[])new String[]{"Lassie", "The Cat"});
    }
}

