/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integrationtest.spring;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.integrationtest.spring.Order;
import org.kie.integrationtest.spring.OrderType;
import org.kie.integrationtest.spring.Party;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(locations={"classpath:springContext.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class OrderTest {
    @KSession(value="orderKnowledgeSession")
    private StatelessKieSession orderRulesProcessor;
    private final Party buyer = new Party();
    private final Party seller = new Party();

    @Test
    public void testConsignmentOrder() {
        this.testOrder(new Order(this.seller, this.buyer, OrderType.CONSIGNMENT), 0);
        this.testOrder(new Order(this.buyer, this.seller, OrderType.CONSIGNMENT), 0);
        this.testOrder(new Order(this.buyer, this.buyer, OrderType.CONSIGNMENT), 1);
        this.testOrder(new Order(this.seller, this.seller, OrderType.CONSIGNMENT), 1);
    }

    @Test
    public void testSalesOrder() {
        this.testOrder(new Order(this.seller, this.buyer, OrderType.SALE), 0);
        this.testOrder(new Order(this.buyer, this.seller, OrderType.SALE), 0);
        this.testOrder(new Order(this.buyer, this.buyer, OrderType.SALE), 1);
        this.testOrder(new Order(this.seller, this.seller, OrderType.SALE), 1);
    }

    @Test
    public void testTransferOrder() {
        this.testOrder(new Order(this.buyer, this.buyer, OrderType.TRANSFER), 0);
        this.testOrder(new Order(this.seller, this.seller, OrderType.TRANSFER), 0);
        this.testOrder(new Order(this.buyer, this.seller, OrderType.TRANSFER), 1);
        this.testOrder(new Order(this.seller, this.buyer, OrderType.TRANSFER), 1);
    }

    private void testOrder(Order order, int errorCount) {
        HashSet errors = new HashSet();
        this.orderRulesProcessor.execute(Arrays.asList(order, errors));
        Assert.assertEquals((long)errorCount, (long)errors.size());
    }
}

