/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AccumulateUnsupportedWithModelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AccumulateUnsupportedWithModelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMVELAccumulate() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateMVEL.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new Person("Bob", "stilton", 20));
            wm.insert((Object)new Person("Mark", "provolone"));
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Cheese("brie", 5));
            wm.insert((Object)new Cheese("provolone", 150));
            wm.fireAllRules();
            Assert.assertEquals((Object)165, results.get(0));
            Assert.assertEquals((Object)10, results.get(1));
            Assert.assertEquals((Object)150, results.get(2));
            Assert.assertEquals((Object)10, results.get(3));
            Assert.assertEquals((Object)210, results.get(4));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMVELAccumulate2WM() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateMVEL.drl"});
        KieSession wm1 = kbase.newKieSession();
        try {
            ArrayList results1 = new ArrayList();
            wm1.setGlobal("results", results1);
            ArrayList results2 = new ArrayList();
            KieSession wm2 = kbase.newKieSession();
            try {
                wm2.setGlobal("results", results2);
                wm1.insert((Object)new Person("Bob", "stilton", 20));
                wm1.insert((Object)new Person("Mark", "provolone"));
                wm2.insert((Object)new Person("Bob", "stilton", 20));
                wm2.insert((Object)new Person("Mark", "provolone"));
                wm1.insert((Object)new Cheese("stilton", 10));
                wm1.insert((Object)new Cheese("brie", 5));
                wm2.insert((Object)new Cheese("stilton", 10));
                wm1.insert((Object)new Cheese("provolone", 150));
                wm2.insert((Object)new Cheese("brie", 5));
                wm2.insert((Object)new Cheese("provolone", 150));
                wm1.fireAllRules();
                wm2.fireAllRules();
            }
            finally {
                wm2.dispose();
            }
            Assert.assertEquals((Object)165, results1.get(0));
            Assert.assertEquals((Object)10, results1.get(1));
            Assert.assertEquals((Object)150, results1.get(2));
            Assert.assertEquals((Object)10, results1.get(3));
            Assert.assertEquals((Object)210, results1.get(4));
            Assert.assertEquals((Object)165, results2.get(0));
            Assert.assertEquals((Object)10, results2.get(1));
            Assert.assertEquals((Object)150, results2.get(2));
            Assert.assertEquals((Object)10, results2.get(3));
            Assert.assertEquals((Object)210, results2.get(4));
        }
        finally {
            wm1.dispose();
        }
    }
}

