/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class GlobalTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GlobalTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReturnValueAndGlobal() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\n\nglobal java.lang.String cheeseType;\nglobal java.util.List   matchingList;\nglobal java.util.List   nonMatchingList;\n\n\nrule \"Match type\"\n    when\n        $cheese : Cheese( type == (cheeseType) )\n    then\n        matchingList.add( $cheese );\nend\n\nrule \"Non matching type\"\n    when\n        $cheese : Cheese( type != (cheeseType) )\n    then\n        nonMatchingList.add( $cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList matchlist = new ArrayList();
            ksession.setGlobal("matchingList", matchlist);
            ArrayList nonmatchlist = new ArrayList();
            ksession.setGlobal("nonMatchingList", nonmatchlist);
            ksession.setGlobal("cheeseType", (Object)"stilton");
            Cheese stilton1 = new Cheese("stilton", 5);
            Cheese stilton2 = new Cheese("stilton", 7);
            Cheese brie = new Cheese("brie", 4);
            ksession.insert((Object)stilton1);
            ksession.insert((Object)stilton2);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)matchlist.size());
            Assert.assertEquals((long)1L, (long)nonmatchlist.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalAccess() {
        String drl = "import org.drools.core.base.MapGlobalResolver;\nglobal java.lang.String myGlobal;\nglobal String unused; \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.core.base.MapGlobalResolver;\nglobal java.lang.String myGlobal;\nglobal String unused; \n"});
        String sample = "default string";
        KieSession session1 = kbase.newKieSession();
        try {
            session1.setGlobal("myGlobal", (Object)"Testing 1");
            session1.insert((Object)"default string");
            session1.fireAllRules();
            Map.Entry[] entries1 = ((MapGlobalResolver)session1.getGlobals()).getGlobals();
            Assert.assertEquals((long)1L, (long)entries1.length);
            Assert.assertEquals(entries1[0].getValue(), (Object)"Testing 1");
            Assert.assertEquals((long)1L, (long)session1.getGlobals().getGlobalKeys().size());
            Assert.assertTrue((boolean)session1.getGlobals().getGlobalKeys().contains("myGlobal"));
        }
        finally {
            session1.dispose();
        }
        StatelessKieSession session2 = kbase.newStatelessKieSession();
        session2.setGlobal("myGlobal", (Object)"Testing 2");
        session2.execute((Object)"default string");
        Map.Entry[] entries2 = ((MapGlobalResolver)session2.getGlobals()).getGlobals();
        Assert.assertEquals((long)1L, (long)entries2.length);
        Assert.assertEquals(entries2[0].getValue(), (Object)"Testing 2");
        Assert.assertEquals((long)1L, (long)session2.getGlobals().getGlobalKeys().size());
        Assert.assertTrue((boolean)session2.getGlobals().getGlobalKeys().contains("myGlobal"));
        StatefulKnowledgeSession session3 = ((StatelessKnowledgeSessionImpl)session2).newWorkingMemory();
        try {
            session3.insert((Object)"default string");
            session3.fireAllRules();
            Map.Entry[] entries3 = ((MapGlobalResolver)session3.getGlobals()).getGlobals();
            Assert.assertEquals((long)1L, (long)entries3.length);
            Assert.assertEquals(entries3[0].getValue(), (Object)"Testing 2");
            Assert.assertEquals((long)1L, (long)session3.getGlobals().getGlobalKeys().size());
            Assert.assertTrue((boolean)session3.getGlobals().getGlobalKeys().contains("myGlobal"));
            session3.setGlobal("myGlobal", (Object)"Testing 3 Over");
            entries3 = ((MapGlobalResolver)session3.getGlobals()).getGlobals();
            Assert.assertEquals((long)1L, (long)entries3.length);
            Assert.assertEquals(entries3[0].getValue(), (Object)"Testing 3 Over");
            Assert.assertEquals((long)1L, (long)session3.getGlobals().getGlobalKeys().size());
            Assert.assertTrue((boolean)session3.getGlobals().getGlobalKeys().contains("myGlobal"));
        }
        finally {
            session3.dispose();
        }
        StatefulKnowledgeSession session4 = ((StatelessKnowledgeSessionImpl)session2).newWorkingMemory();
        try {
            session4.setGlobal("myGlobal", (Object)"Testing 4");
            session4.insert((Object)"default string");
            session4.fireAllRules();
            Map.Entry[] entries4 = ((MapGlobalResolver)session4.getGlobals()).getGlobals();
            Assert.assertEquals((long)1L, (long)entries4.length);
            Assert.assertEquals(entries4[0].getValue(), (Object)"Testing 4");
            Assert.assertEquals((long)1L, (long)session4.getGlobals().getGlobalKeys().size());
            Assert.assertTrue((boolean)session4.getGlobals().getGlobalKeys().contains("myGlobal"));
        }
        finally {
            session4.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalNullGlobal() {
        String drl = "import " + Cheese.class.getCanonicalName() + "\nglobal Boolean b\nrule R when\n  eval(b)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("b", null);
            Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }
}

