/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.util.Collection;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.testcoverage.common.model.Cell;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.SerializationHelper;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CellTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CellTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCell() throws IOException, ClassNotFoundException {
        String drl = "package evalmodify;\n\nimport " + Cell.class.getCanonicalName() + "\nimport java.lang.Integer\n\nrule \"test eval\"\n    when\n        cell1 : Cell(value1:value != 0)\n        cell2 : Cell(value2:value < value1)\n        eval (true)\n    then\n        cell2.setValue(value2 + 1);\n        update(cell2);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cell-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration(), env);
        try {
            Cell cell1 = new Cell(9);
            Cell cell = new Cell(0);
            session.insert((Object)cell1);
            session.insert((Object)cell);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
            session.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)9L, (long)cell.getValue());
            } else {
                Assert.assertEquals((long)0L, (long)cell.getValue());
            }
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFreeFormExpressions() {
        String drl = "package org.drools.compiler\nimport " + Cell.class.getCanonicalName() + "\nrule r1\nwhen\n    $p1 : Cell( row == 2 )\n    $p2 : Cell( row == $p1.row + 1, row == ($p1.row + 1), row == 1 + $p1.row, row == (1 + $p1.row) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cell-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cell c1 = new Cell(1, 2, 0);
            Cell c2 = new Cell(1, 3, 0);
            ksession.insert((Object)c1);
            ksession.insert((Object)c2);
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }
}

