/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.ruleunit.RuleUnitFactory;
import org.drools.core.ruleunit.RuleUnitUtil;
import org.drools.core.util.ClassUtils;
import org.drools.testcoverage.common.model.LongAddress;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.DebugList;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.UnitVar;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class RuleUnitTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleUnitTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            Assert.assertEquals((long)2L, (long)executor.run((RuleUnit)new AdultUnit((DataSource<Person>)persons)));
            Assert.assertEquals((long)1L, (long)executor.run(NotAdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = DataSource.create((Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            executor.bindVariable("persons", (Object)persons);
            Assert.assertEquals((long)2L, (long)executor.run(AdultUnit.class));
            Assert.assertEquals((long)1L, (long)executor.run(NotAdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnboundDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = DataSource.create((Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            Assert.assertEquals((long)2L, (long)executor.run((RuleUnit)new AdultUnit((DataSource<Person>)persons)));
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)new NotAdultUnit((DataSource<Person>)persons)));
        }
        finally {
            executor.dispose();
        }
    }

    @Test
    public void testRuleWithoutUnitsIsNotExecutor() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult when\n    Person(age >= 18, $name : name)\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult when\n    Person(age < 18, $name : name)\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Assertions.assertThatThrownBy(() -> RuleUnitExecutor.create().bind(kbase)).isInstanceOf(IllegalStateException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunUnexistingUnit() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            Assertions.assertThatThrownBy(() -> executor.run(NotAdultUnit.class)).isInstanceOf(IllegalStateException.class);
        }
        finally {
            executor.dispose();
        }
    }

    @Test
    public void testDisallowToMixRulesWithAndWithoutUnit() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult when\n    Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        Assertions.assertThatThrownBy(() -> KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl})).isInstanceOf(IllegalStateException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleUnitInvocationFromConsequence() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    $p : Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18); }\n    drools.run( AdultUnit.class );end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            ArrayList log = new ArrayList();
            executor.bindVariable("log", log);
            Assert.assertEquals((long)4L, (long)executor.run(NotAdultUnit.class));
            List<String> expectedLogs = Arrays.asList(RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit yielded to org.drools.compiler.integrationtests.RuleUnitTest$AdultUnit", RuleUnitTest.class.getCanonicalName() + "$AdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$AdultUnit ended.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit ended.");
            Assert.assertEquals(expectedLogs, log);
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStackedRuleUnitInvocationFromConsequence() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    $p : Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18); }\n    drools.run( AdultUnit.class );end\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 2), new Person("Sofia", 6)});
            ArrayList log = new ArrayList();
            executor.bindVariable("log", log);
            Assert.assertEquals((long)4L, (long)executor.run(NotAdultUnit.class));
            List<String> expectedLogs = Arrays.asList(RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit yielded to org.drools.compiler.integrationtests.RuleUnitTest$AdultUnit", RuleUnitTest.class.getCanonicalName() + "$AdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$AdultUnit ended.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit yielded to org.drools.compiler.integrationtests.RuleUnitTest$AdultUnit", RuleUnitTest.class.getCanonicalName() + "$AdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$AdultUnit ended.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit ended.");
            Assert.assertEquals(expectedLogs, log);
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyOnDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\n    results.add($name);\nend\nrule NotAdult @Unit( AdultUnit.class ) when\n    $p : Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18); }\n    drools.run( AdultUnit.class );end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            ArrayList results = new ArrayList();
            executor.bindVariable("results", results);
            Assert.assertEquals((long)4L, (long)executor.run(AdultUnit.class));
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena", "Sofia")));
        }
        finally {
            executor.dispose();
        }
    }

    @Test
    public void testNotExistingDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from adults\nthen\n    System.out.println($name + \" is adult\");\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReactiveDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + ReactiveAdultUnit.class.getCanonicalName() + "\nimport " + ReactiveNotAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( ReactiveAdultUnit.class) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( ReactiveNotAdultUnit.class ) when\n    Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42)});
            ReactiveAdultUnit adultUnit = new ReactiveAdultUnit((DataSource<Person>)persons, null);
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)adultUnit));
            ReactiveNotAdultUnit notAdultUnit = new ReactiveNotAdultUnit((DataSource<Person>)persons);
            Assert.assertEquals((long)0L, (long)executor.run((RuleUnit)notAdultUnit));
            persons.insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)0L, (long)executor.run((RuleUnit)adultUnit));
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)notAdultUnit));
            persons.insert((Object)new Person("Marilena", 44));
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)adultUnit));
            Assert.assertEquals((long)0L, (long)executor.run((RuleUnit)notAdultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testReactiveDataSourceWithRunUntilHalt() throws Exception {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + ReactiveAdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( ReactiveAdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");    list.add($name);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DebugList list = new DebugList();
            executor.bindVariable("list", (Object)list);
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42)});
            ReactiveAdultUnit adultUnit = new ReactiveAdultUnit((DataSource<Person>)persons, (List<String>)list);
            Semaphore ready = new Semaphore(0, true);
            list.onItemAdded = l -> ready.release();
            new Thread(() -> executor.runUntilHalt((RuleUnit)adultUnit)).start();
            ready.acquire();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Mario", (Object)list.get(0));
            list.clear();
            list.onItemAdded = l -> ready.release();
            persons.insert((Object)new Person("Sofia", 4));
            persons.insert((Object)new Person("Marilena", 44));
            ready.acquire();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Marilena", (Object)list.get(0));
        }
        finally {
            executor.halt();
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamingConventionOnDrlFile() {
        String drl1 = "package org.kie.test;\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : /persons[age >= 18]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        String javaRuleUnit = "package org.kie.test;\n\nimport " + Person.class.getCanonicalName() + ";\nimport " + RuleUnit.class.getCanonicalName() + ";\nimport " + DataSource.class.getCanonicalName() + ";\n\npublic class MyRuleUnit implements RuleUnit {\n    private DataSource<Person> persons;\n\n    public DataSource<Person> getPersons() {\n        return persons;\n    }\n}\n";
        KieModuleModel kieModuleModel = KieUtil.getKieModuleModel((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, new HashMap());
        KieServices ks = KieServices.get();
        ReleaseId releaseId = ks.newReleaseId(UUID.randomUUID().toString(), "test-artifact", "1.0");
        String path = "org/kie/test/MyRuleUnit";
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId);
        kfs.writeKModuleXML(ks.newKieModuleModel().toXML()).write("src/main/resources/org/kie/test/MyRuleUnit.drl", drl1).write("src/main/java/org/kie/test/MyRuleUnit.java", javaRuleUnit);
        KieModule kieModule = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId, (KieModuleModel)kieModuleModel, (KieFileSystem)kfs);
        KieContainer kcontainer = ks.newKieContainer(releaseId);
        KieBase kbase = kcontainer.getKieBase();
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42)});
            RuleUnit ruleUnit = new RuleUnitFactory().bindVariable("persons", (Object)persons).getOrCreateRuleUnit((InternalRuleUnitExecutor)executor, "org.kie.test.MyRuleUnit", kcontainer.getClassLoader());
            Assert.assertEquals((long)1L, (long)executor.run(ruleUnit));
            persons.insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)0L, (long)executor.run(ruleUnit));
            persons.insert((Object)new Person("Marilena", 44));
            Assert.assertEquals((long)1L, (long)executor.run(ruleUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPath() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    $p : /persons[age >= 18]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            AdultUnit adultUnit = new AdultUnit((DataSource<Person>)persons);
            Assert.assertEquals((long)2L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPathAndNot() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    not /persons[age >= 18]\nthen\n    System.out.println(\"No adults\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 4), new Person("Marilena", 17), new Person("Sofia", 4)});
            AdultUnit adultUnit = new AdultUnit((DataSource<Person>)persons);
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPathAndNotNoMatch() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    not /persons[age >= 18]\nthen\n    System.out.println(\"No adults\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 44), new Person("Marilena", 170), new Person("Sofia", 18)});
            AdultUnit adultUnit = new AdultUnit((DataSource<Person>)persons);
            Assert.assertEquals((long)0L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarResolution() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nrule Adult @Unit( AdultUnit.class ) when\n    $p : /persons[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult and greater than \" + adultAge);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            executor = executor.bindVariable("adultAge", (Object)18);
            Assert.assertEquals((long)2L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnitDeclaration() {
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    Person(age >= adultAge, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(NotAdultUnit.class) + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\nrule NotAdult when\n    $p : Person(age < 18, $name : name) from persons\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18); }\n    drools.run( AdultUnit.class );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            ArrayList log = new ArrayList();
            executor.bindVariable("log", log).bindVariable("adultAge", (Object)18);
            Assert.assertEquals((long)4L, (long)executor.run(NotAdultUnit.class));
            List<String> expectedLogs = Arrays.asList(RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit yielded to org.drools.compiler.integrationtests.RuleUnitTest$AdultUnit", RuleUnitTest.class.getCanonicalName() + "$AdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$AdultUnit ended.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit started.", RuleUnitTest.class.getCanonicalName() + "$NotAdultUnit ended.");
            Assert.assertEquals(expectedLogs, log);
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindingWithNamedVars() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + NamedVarsUnit.class.getCanonicalName() + "\nrule Adult @Unit( NamedVarsUnit.class ) when\n    $p : /persons[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult and greater than \" + adultAge);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("data", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            executor.bindVariable("minAge", (Object)18);
            Assert.assertEquals((long)2L, (long)executor.run(NamedVarsUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuardedUnit() {
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(BoxOfficeUnit.class) + ";\nimport " + BoxOffice.class.getCanonicalName() + "\nimport " + TicketIssuerUnit.class.getCanonicalName() + "\n\nrule BoxOfficeIsOpen when\n    $box: /boxOffices[ open ]\nthen\n    drools.guard( TicketIssuerUnit.class );end";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(TicketIssuerUnit.class) + ";\nimport " + Person.class.getCanonicalName() + "\nimport " + AdultTicket.class.getCanonicalName() + "\nrule IssueAdultTicket when\n    $p: /persons[ age >= 18 ]\nthen\n    tickets.insert(new AdultTicket($p));\nend\nrule RegisterAdultTicket when\n    $t: /tickets\nthen\n    results.add( $t.getPerson().getName() );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[0]);
            DataSource boxOffices = executor.newDataSource("boxOffices", (Object[])new BoxOffice[0]);
            executor.newDataSource("tickets", new Object[0]);
            ArrayList list = new ArrayList();
            executor.bindVariable("results", list);
            BoxOffice office1 = new BoxOffice(true);
            FactHandle officeFH1 = boxOffices.insert((Object)office1);
            BoxOffice office2 = new BoxOffice(true);
            FactHandle officeFH2 = boxOffices.insert((Object)office2);
            persons.insert((Object)new Person("Mario", 40));
            executor.run(BoxOfficeUnit.class);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Mario", list.get(0));
            list.clear();
            persons.insert((Object)new Person("Matteo", 30));
            executor.run(BoxOfficeUnit.class);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Matteo", list.get(0));
            list.clear();
            office1.setOpen(false);
            boxOffices.update(officeFH1, (Object)office1, new String[0]);
            persons.insert((Object)new Person("Mark", 35));
            executor.run(BoxOfficeUnit.class);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Mark", list.get(0));
            list.clear();
            office2.setOpen(false);
            boxOffices.update(officeFH2, (Object)office2, new String[0]);
            persons.insert((Object)new Person("Edson", 35));
            executor.run(BoxOfficeUnit.class);
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexData() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(ComplexDataUnit.class) + "\nimport " + RequestData.class.getCanonicalName() + "\nimport " + ParameterHolder.class.getCanonicalName() + "\nimport " + InternalData.class.getCanonicalName() + "\nimport " + InternalDataFactory.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\n\n\nrule 'Extract Named Parameter out of Request - Name'\nwhen\n   $request: RequestData( $id: requestId != null, modelId != null, $parameters: parameters != null ) from requestData\n   $param: ParameterHolder( capitalizedName == \"Name\" ) from $parameters\nthen\n   System.out.printf(\"Parameter found: %s with value of %s%n\",$param.getCapitalizedName(),$param.getValue());\n   InternalData d = InternalDataFactory.get().createInternalData($param);\n   insert(d); \nend\n\n\nrule 'Extract Named Parameter out of Request - LikesBeets'\nwhen\n   $request: RequestData( $id: requestId != null, modelId != null, $parameters: parameters != null ) from requestData\n   $param: ParameterHolder( capitalizedName == \"LikesBeets\" ) from $parameters\nthen\n   System.out.printf(\"Parameter found: %s with value of %s%n\",$param.getCapitalizedName(),$param.getValue());\n   InternalData d = InternalDataFactory.get().createInternalData($param);\n   insert(d); \nend\n\n\nrule 'Extract Named Parameter out of Request - HairColor'\nwhen\n   $request: RequestData( $id: requestId != null, modelId != null, $parameters: parameters != null ) from requestData\n   $param: ParameterHolder( capitalizedName == \"HairColor\" ) from $parameters\nthen\n   System.out.printf(\"Parameter found: %s with value of %s%n\",$param.getCapitalizedName(),$param.getValue());\n   InternalData d = InternalDataFactory.get().createInternalData($param);\n   insert(d); \nend\n\nrule 'Extract Named Parameter out of Request - Age'\nwhen\n   $request: RequestData( $id: requestId != null, modelId != null, $parameters: parameters != null ) from requestData\n   $param: ParameterHolder( capitalizedName == \"Age\" ) from $parameters\nthen\n   System.out.printf(\"Parameter found: %s with value of %f%n\",$param.getCapitalizedName(),$param.getValue());\n   InternalData d = InternalDataFactory.get().createInternalData($param);\n   insert(d); \nend\n\nrule 'Check InternalData is inserted - Age' \nwhen\n   $i: InternalData( capitalizedName == \"Age\" )\nthen\n   System.out.printf(\"Actual Age: %f   Factored Age: %f%n\",$i.getValue(),$i.getTransformed()); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            RequestData request = new RequestData("123", "simple");
            request.addParameter("name", "Lance", String.class);
            request.addParameter("age", 54.5, Double.class);
            request.addParameter("hairColor", "bald", String.class);
            request.addParameter("likesBeets", false, Boolean.class);
            executor.newDataSource("requestData", (Object[])new RequestData[]{request});
            Assert.assertEquals((long)5L, (long)executor.run(ComplexDataUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiLevelGuards() {
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(Unit0.class) + "\nimport " + UnitA.class.getCanonicalName() + "\nrule X when\n    $b: /ds#Boolean\nthen\n    Boolean b = $b;\n    drools.guard( UnitA.class );\nend";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(UnitA.class) + "\nimport " + UnitB.class.getCanonicalName() + "\nrule A when\n    $s: /ds#String\nthen\n    drools.guard( UnitB.class );end";
        String drl3 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(UnitB.class) + "\nimport " + UnitB.class.getCanonicalName() + "\nrule B when\n    $i: /ds#Integer\nthen\n    list.add($i);end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2, drl3});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource ds = executor.newDataSource("ds", new Object[0]);
            ArrayList list = new ArrayList();
            executor.bindVariable("list", list);
            ds.insert((Object)1);
            executor.run(Unit0.class);
            Assert.assertEquals((long)0L, (long)list.size());
            FactHandle guardA = ds.insert((Object)true);
            executor.run(Unit0.class);
            Assert.assertEquals((long)0L, (long)list.size());
            ds.insert((Object)"test");
            executor.run(Unit0.class);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)1L, (long)((Integer)list.get(0)).intValue());
            list.clear();
            ds.insert((Object)2);
            executor.run(Unit0.class);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)2L, (long)((Integer)list.get(0)).intValue());
            list.clear();
            ds.delete(guardA);
            ds.insert((Object)3);
            executor.run(Unit0.class);
            Assert.assertEquals((long)0L, (long)list.size());
            ds.insert((Object)true);
            executor.run(Unit0.class);
            Assert.assertEquals((long)1L, (long)list.size());
            list.clear();
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleUnitIdentity() {
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(Unit0.class) + "\nimport " + AgeCheckUnit.class.getCanonicalName() + "\n\nrule R1 when\n    $i: /ds#Integer\nthen\n    drools.guard( new AgeCheckUnit($i) );end\nrule RegisterAdultTicket when\n    $s: /ds#String\nthen\n    drools.guard( new AgeCheckUnit($s.length()) );end";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AgeCheckUnit.class) + ";\nimport " + Person.class.getCanonicalName() + "\nrule CheckAge when\n    $p : /persons[ age > minAge ]\nthen\n    list.add($p.getName() + \">\" + minAge);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DataSource ds = executor.newDataSource("ds", new Object[0]);
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Sofia", 4)});
            ArrayList list = new ArrayList();
            executor.bindVariable("list", list);
            ds.insert((Object)"test");
            ds.insert((Object)3);
            ds.insert((Object)4);
            executor.run(Unit0.class);
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertTrue((boolean)list.containsAll(Arrays.asList("Mario>4", "Mario>3", "Sofia>3")));
            list.clear();
            ds.insert((Object)"xxx");
            ds.insert((Object)"yyyy");
            executor.run(Unit0.class);
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPropertyReactiveModify() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p: /persons[ age < 18 ]\nthen\n    System.out.println($p.getName() + \" is NOT adult\");\n    modify($p) { setHappy(true); }\nend";
        KieServices ks = KieServices.Factory.get();
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALWAYS.toString());
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-property-reactive-modify", "1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieContainer container = ks.newKieContainer(releaseId1);
        KieBase kbase = container.getKieBase();
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            Person mario = new Person("Mario", 42);
            Person sofia = new Person("Sofia", 4);
            DataSource persons = executor.newDataSource("persons", (Object[])new Person[0]);
            persons.insert((Object)mario);
            FactHandle sofiaFh = persons.insert((Object)sofia);
            executor.run(AdultUnit.class);
            Assert.assertTrue((boolean)sofia.isHappy());
            Assert.assertFalse((boolean)mario.isHappy());
            sofia.setAge(5);
            persons.update(sofiaFh, (Object)sofia, new String[]{"age"});
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
            sofia.setHair("Brown");
            persons.update(sofiaFh, (Object)sofia, new String[]{"hair"});
            Assert.assertEquals((long)0L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoPartsOOPath() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nimport " + LongAddress.class.getCanonicalName() + "\nrule Adult when\n    $a: /persons[ age > 18 ]/addresses#LongAddress[ country == \"it\" ]\nthen\n    System.out.println($a.getCountry());\nend";
        KieServices ks = KieServices.Factory.get();
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALWAYS.toString());
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-two-parts-oopath", "1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieContainer container = ks.newKieContainer(releaseId1);
        KieBase kbase = container.getKieBase();
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            Person mario = new Person("Mario", 43);
            mario.setAddresses(Collections.singletonList(new LongAddress("street", "suburb", "zipCode", "it")));
            Person mark = new Person("Mark", 40);
            mark.setAddresses(Collections.singletonList(new LongAddress("street", "suburb", "zipCode", "uk")));
            executor.newDataSource("persons", (Object[])new Person[]{mario, mark});
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedOOPath() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nimport " + LongAddress.class.getCanonicalName() + "\nrule Adult when\n    $p: /persons[ age > 18, $a: /addresses#LongAddress[ country == \"it\" ] ]\nthen\n    System.out.println($p.getName() + \" is in \" + $a.getCountry());\nend";
        KieServices ks = KieServices.Factory.get();
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALWAYS.toString());
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-nested-oopath", "1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieContainer container = ks.newKieContainer(releaseId1);
        KieBase kbase = container.getKieBase();
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            Person mario = new Person("Mario", 43);
            mario.setAddresses(Collections.singletonList(new LongAddress("street", "suburb", "zipCode", "it")));
            Person mark = new Person("Mark", 40);
            mark.setAddresses(Collections.singletonList(new LongAddress("street", "suburb", "zipCode", "uk")));
            executor.newDataSource("persons", (Object[])new Person[]{mario, mark});
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPathOnList() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnitWithList.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : /persons[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            List<Person> persons = Arrays.asList(new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4));
            AdultUnitWithList adultUnit = new AdultUnitWithList(persons);
            Assert.assertEquals((long)2L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPathOnArray() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnitWithArray.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : /persons[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            AdultUnitWithArray adultUnit = new AdultUnitWithArray(new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4));
            Assert.assertEquals((long)2L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithOOPathOnSingleItem() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnitWithSingleItem.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : /person[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            AdultUnitWithSingleItem adultUnit = new AdultUnitWithSingleItem(new Person("Mario", 42));
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testReactiveOnUnitCreatingDataSource() throws Exception {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnitCreatingDataSource.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    Person(age >= 18, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");    list.add($name);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            DebugList list = new DebugList();
            executor.bindVariable("list", (Object)list);
            AdultUnitCreatingDataSource adultUnit = new AdultUnitCreatingDataSource((List<String>)list);
            adultUnit.insertPerson(new Person("Mario", 42));
            Semaphore ready = new Semaphore(0, true);
            list.onItemAdded = l -> ready.release();
            new Thread(() -> executor.runUntilHalt((RuleUnit)adultUnit)).start();
            ready.acquire();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Mario", (Object)list.get(0));
            list.clear();
            list.onItemAdded = l -> ready.release();
            adultUnit.insertPerson(new Person("Sofia", 4));
            adultUnit.insertPerson(new Person("Marilena", 44));
            ready.acquire();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Marilena", (Object)list.get(0));
        }
        finally {
            executor.halt();
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleUnitFromKieContainer() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnitWithSingleItem.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : /person[age >= adultAge]\nthen\n    System.out.println($p.getName() + \" is adult\");\nend";
        KieContainer kieContainer = KieUtil.getKieContainerFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, (String[])new String[]{drl});
        RuleUnitExecutor executor = kieContainer.newRuleUnitExecutor();
        try {
            Assert.assertTrue((boolean)(executor.getKieSession().getSessionClock() instanceof SessionPseudoClock));
            AdultUnitWithSingleItem adultUnit = new AdultUnitWithSingleItem(new Person("Mario", 42));
            Assert.assertEquals((long)1L, (long)executor.run((RuleUnit)adultUnit));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunOrder() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + FlowUnit.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nglobal java.util.List list;\nrule Flow @Unit( FlowUnit.class ) when\nthen\n    drools.run( NotAdultUnit.class );\n    drools.run( AdultUnit.class );\nend\nrule Adult @Unit( AdultUnit.class ) when\n    Person(age >= 18, $name : name) from persons\nthen\n    list.add($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    Person(age < 18, $name : name) from persons\nthen\n    list.add($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            ArrayList list = new ArrayList();
            executor.getKieSession().setGlobal("list", list);
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Sofia", 4)});
            Assert.assertEquals((long)3L, (long)executor.run(FlowUnit.class));
            Assert.assertEquals(list, Arrays.asList("Sofia is NOT adult", "Mario is adult"));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleUnitWithAccumulate() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nglobal java.util.List list;\nrule AccumulateAdults @Unit( AdultUnit.class ) when\n   accumulate( $p: Person( $age: age >= 18 ) from persons, \n               $sum : sum( $age ) )\nthen\n   list.add($sum); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            ArrayList list = new ArrayList();
            executor.getKieSession().setGlobal("list", list);
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)86L, (long)((Integer)list.get(0)).intValue());
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyGlobalFact() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult when\n    $p : Person(age < 18, $name : name)\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.getKieSession().insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyGlobalFactWithMvelDialect() {
        String drl = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(AdultUnit.class) + "\nimport " + Person.class.getCanonicalName() + "\nrule Adult dialect \"mvel\" when\n    $p : Person(age < 18, $name : name)\nthen\n    System.out.println($name + \" is NOT adult\");\n    modify($p) { setAge(18) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.getKieSession().insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)1L, (long)executor.run(AdultUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixingGlobalDataAndDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + FlowUnit.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + NotAdultUnit.class.getCanonicalName() + "\nrule Flow @Unit( FlowUnit.class ) when\nthen\n    insert(18);\n    drools.run( NotAdultUnit.class );\n    drools.run( AdultUnit.class );\nend\nrule Adult @Unit( AdultUnit.class ) when\n    $i : Integer()\n    Person(age >= $i, $name : name) from persons\nthen\n    System.out.println($name + \" is adult\");\nend\nrule NotAdult @Unit( NotAdultUnit.class ) when\n    Person($age : age < 18, $name : name) from persons\n    $i : Integer(this >= $age)\nthen\n    System.out.println($name + \" is NOT adult\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4)});
            Assert.assertEquals((long)4L, (long)executor.run(FlowUnit.class));
        }
        finally {
            executor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFromDataSource() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + FlowUnit.class.getCanonicalName() + "\nimport " + AdultUnit.class.getCanonicalName() + "\nimport " + FilterUnit.class.getCanonicalName() + "\nrule Flow @Unit( FlowUnit.class ) when\nthen\n    drools.run( FilterUnit.class );\n    drools.run( AdultUnit.class );\nend\nrule filter @Unit( FilterUnit.class ) when\n    $p:Person(name str[startsWith] \"D\") from persons\nthen\n    System.out.println(\"Deleting person: \" + $p.getName() + \". Sorry man, your name starts with a 'D' ....\");\n    persons.delete( $p );\nend\nrule AdultUnit @Unit( AdultUnit.class ) when\n    Person($age : age > 18, $name : name) from persons\nthen\n    results.add($name);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        try {
            executor.newDataSource("persons", (Object[])new Person[]{new Person("Mario", 43), new Person("Duncan", 34), new Person("Sofia", 6)});
            ArrayList results = new ArrayList();
            executor.bindVariable("results", results);
            Assert.assertEquals((long)3L, (long)executor.run(FlowUnit.class));
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)"Mario", results.get(0));
        }
        finally {
            executor.dispose();
        }
    }

    private KieBase kieBaseMainGuardSubunitRunBackToMain(boolean currentStyle) {
        System.out.println("Running with style: " + currentStyle);
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(MainHouseUnit.class) + "\nimport " + DayPartUnit.class.getCanonicalName() + "\nimport " + SwitchUnit.class.getCanonicalName() + "\nrule GuardDayPartUnit when\n    Object() from now \n    not( String() from part ) \nthen\n    System.out.println(\"Guarding DayPartUnit\");\n    drools.guard(DayPartUnit.class);\nend\nrule GuardSwitchUnit when\n    String() from part \n    not( Boolean() from switch1 ) \nthen\n    System.out.println(\"Guarding SwitchUnit\");\n    drools.guard(SwitchUnit.class);\nend\n";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(DayPartUnit.class) + "\nimport " + MainHouseUnit.class.getCanonicalName() + "\nrule doDayPartUnit when\n    $n : Object() from now \nthen\n    System.out.println(\"Inside DayPartUnit: \"+$n);\n    part.insert(\"Morning\");\n" + (currentStyle ? "//" : "") + " drools.run(MainHouseUnit.class);\nend\n";
        String drl3 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(SwitchUnit.class) + "\nimport " + MainHouseUnit.class.getCanonicalName() + "\nrule doSwitchUnit when\n    $n : String() from part \nthen\n    System.out.println(\"Inside SwitchUnit: \"+$n);\n    switch1.insert(true);\n" + (currentStyle ? "//" : "") + " drools.run(MainHouseUnit.class);\nend\n";
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rule-unit-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2, drl3});
    }

    @Test
    public void testGuardAndRunBack() {
        String drl1 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(EmptyUnit.class) + "\nimport " + StringDSUnit.class.getCanonicalName() + "\nrule RGuard when\nthen\n    System.out.println(\"Guarding StringDSUnit\");\n    drools.guard(StringDSUnit.class);\nend\n";
        String drl2 = "package org.drools.compiler.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(StringDSUnit.class) + "\nimport " + EmptyUnit.class.getCanonicalName() + "\nrule RGoBack when\nthen\n    System.out.println(\"Inside StringDSUnit: \");\n    drools.run(EmptyUnit.class);\nend\n";
        KieBase kbase = new KieHelper().addContent(drl1, ResourceType.DRL).addContent(drl2, ResourceType.DRL).build(new KieBaseOption[0]);
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        executor.newDataSource("strings", (Object[])new String[]{"abc", "xyz"});
        EmptyUnit emptyUnit = new EmptyUnit();
        executor.run((RuleUnit)emptyUnit);
    }

    public static class StringDSUnit
    implements RuleUnit {
        private DataSource<String> strings;

        public DataSource<String> getStrings() {
            return this.strings;
        }
    }

    public static class EmptyUnit
    implements RuleUnit {
    }

    public static class SwitchUnit
    implements RuleUnit {
        private DataSource<String> part;
        private DataSource<Boolean> switch1;

        public DataSource<String> getPart() {
            return this.part;
        }

        public DataSource<Boolean> getSwitch1() {
            return this.switch1;
        }
    }

    public static class DayPartUnit
    implements RuleUnit {
        private DataSource<Date> now;
        private DataSource<Date> aScopedDS;
        private DataSource<String> part;

        public DataSource<Date> getNow() {
            return this.now;
        }

        public DataSource<String> getPart() {
            return this.part;
        }

        public DataSource<Date> getaScopedDS() {
            return this.aScopedDS;
        }
    }

    public static class MainHouseUnit
    implements RuleUnit {
        private DataSource<Date> now;
        private DataSource<String> part;
        private DataSource<Boolean> switch1;

        public DataSource<Date> getNow() {
            return this.now;
        }

        public DataSource<String> getPart() {
            return this.part;
        }

        public DataSource<Boolean> getSwitch1() {
            return this.switch1;
        }
    }

    public static class FilterUnit
    implements RuleUnit {
        private DataSource<Person> persons;

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public void setPersons(DataSource<Person> persons) {
            this.persons = persons;
        }
    }

    public static class FlowUnit
    implements RuleUnit {
    }

    public static class AdultUnitCreatingDataSource
    implements RuleUnit {
        private final DataSource<Person> persons = DataSource.create((Object[])new Person[0]);
        private final List<String> list;

        public AdultUnitCreatingDataSource(List<String> list) {
            this.list = list;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public List<String> getList() {
            return this.list;
        }

        public void insertPerson(Person person) {
            this.persons.insert((Object)person);
        }
    }

    public static class AdultUnitWithSingleItem
    implements RuleUnit {
        private final int adultAge = 18;
        private Person person;

        public AdultUnitWithSingleItem() {
        }

        public AdultUnitWithSingleItem(Person person) {
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }

        public int getAdultAge() {
            return 18;
        }
    }

    public static class AdultUnitWithArray
    implements RuleUnit {
        private final int adultAge = 18;
        private Person[] persons;

        public AdultUnitWithArray() {
        }

        public AdultUnitWithArray(Person ... persons) {
            this.persons = persons;
        }

        public Person[] getPersons() {
            return this.persons;
        }

        public int getAdultAge() {
            return 18;
        }
    }

    public static class AdultUnitWithList
    implements RuleUnit {
        private final int adultAge = 18;
        private List<Person> persons;

        public AdultUnitWithList() {
        }

        public AdultUnitWithList(List<Person> persons) {
            this.persons = persons;
        }

        public List<Person> getPersons() {
            return this.persons;
        }

        public int getAdultAge() {
            return 18;
        }
    }

    public static class AgeCheckUnit
    implements RuleUnit {
        private final int minAge;
        private DataSource<Person> persons;
        private List<String> list;

        public AgeCheckUnit(int minAge) {
            this.minAge = minAge;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public int getMinAge() {
            return this.minAge;
        }

        public List<String> getList() {
            return this.list;
        }

        public RuleUnit.Identity getUnitIdentity() {
            return new RuleUnit.Identity(this.getClass(), new Object[]{this.minAge});
        }

        public String toString() {
            return "AgeCheckUnit(" + this.minAge + ")";
        }
    }

    public static class UnitB
    implements RuleUnit {
        private DataSource<Object> ds;
        private List<Integer> list;

        public DataSource<Object> getDs() {
            return this.ds;
        }

        public List<Integer> getList() {
            return this.list;
        }
    }

    public static class UnitA
    implements RuleUnit {
        private DataSource<Object> ds;

        public DataSource<Object> getDs() {
            return this.ds;
        }
    }

    public static class Unit0
    implements RuleUnit {
        private DataSource<Object> ds;

        public DataSource<Object> getDs() {
            return this.ds;
        }
    }

    public static class TicketIssuerUnit
    implements RuleUnit {
        private DataSource<Person> persons;
        private DataSource<AdultTicket> tickets;
        private List<String> results;

        public TicketIssuerUnit() {
        }

        public TicketIssuerUnit(DataSource<Person> persons, DataSource<AdultTicket> tickets) {
            this.persons = persons;
            this.tickets = tickets;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public DataSource<AdultTicket> getTickets() {
            return this.tickets;
        }

        public List<String> getResults() {
            return this.results;
        }
    }

    public static class BoxOfficeUnit
    implements RuleUnit {
        private DataSource<BoxOffice> boxOffices;

        public DataSource<BoxOffice> getBoxOffices() {
            return this.boxOffices;
        }
    }

    public static class AdultTicket {
        private final Person person;

        public AdultTicket(Person person) {
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }
    }

    public static class BoxOffice {
        private boolean open;

        public BoxOffice(boolean open) {
            this.open = open;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }
    }

    public static class ComplexDataUnit
    implements RuleUnit {
        private DataSource<RequestData> requestData;

        public ComplexDataUnit() {
        }

        public ComplexDataUnit(DataSource<RequestData> requestData) {
            this.requestData = requestData;
        }

        public DataSource<RequestData> getRequestData() {
            return this.requestData;
        }
    }

    public static class RequestData {
        private String requestId;
        private String modelId;
        private final List<ParameterHolder<?>> parameters;

        public RequestData(String requestId, String modelId) {
            this.requestId = requestId;
            this.modelId = modelId;
            this.parameters = new ArrayList();
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getModelId() {
            return this.modelId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public List<ParameterHolder<?>> getParameters() {
            return this.parameters;
        }

        public <T> boolean addParameter(ParameterHolder<T> parameter) {
            return this.parameters.add(parameter);
        }

        public <T> boolean addParameter(String parameterName, T value, Class<T> type) {
            ParameterHolder<T> parameter = new ParameterHolder<T>(this.requestId, parameterName, value, type);
            return this.addParameter(parameter);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
            result = 31 * result + (this.requestId == null ? 0 : this.requestId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestData other = (RequestData)obj;
            if (this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId)) {
                return false;
            }
            if (this.requestId == null) {
                return other.requestId == null;
            }
            return this.requestId.equals(other.requestId);
        }
    }

    public static class ParameterHolder<T> {
        private String requestId;
        private String parmName;
        private T value;
        private Class<T> type;

        public ParameterHolder(String requestId, String parmName, T value, Class<T> type) {
            this.requestId = requestId;
            this.parmName = parmName;
            this.value = value;
            this.type = type;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getParmName() {
            return this.parmName;
        }

        public void setParmName(String parmName) {
            this.parmName = parmName;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public Class<T> getType() {
            return this.type;
        }

        public void setType(Class<T> type) {
            this.type = type;
        }

        public String getCapitalizedName() {
            return this.parmName.substring(0, 1).toUpperCase() + this.parmName.substring(1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parmName == null ? 0 : this.parmName.hashCode());
            result = 31 * result + (this.requestId == null ? 0 : this.requestId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterHolder other = (ParameterHolder)obj;
            if (this.parmName == null ? other.parmName != null : !this.parmName.equals(other.parmName)) {
                return false;
            }
            if (this.requestId == null) {
                return other.requestId == null;
            }
            return this.requestId.equals(other.requestId);
        }
    }

    public static class BooleanData
    extends InternalData<Boolean> {
        public BooleanData(String requestId, String name, Boolean value) {
            super(requestId, name, value, Boolean.class);
        }

        @Override
        public Boolean getTransformed() {
            return (Boolean)this.getValue() == false;
        }
    }

    public static class DoubleData
    extends InternalData<Double> {
        private Double factor = 1.5;

        public DoubleData(String requestId, String name, Double value) {
            super(requestId, name, value, Double.class);
        }

        public Double getFactor() {
            return this.factor;
        }

        public void setFactor(Double factor) {
            this.factor = factor;
        }

        @Override
        public Double getTransformed() {
            return (Double)this.getValue() * this.factor;
        }
    }

    public static class StringData
    extends InternalData<String> {
        public StringData(String requestId, String name, String value) {
            super(requestId, name, value, String.class);
        }

        @Override
        public String getTransformed() {
            return ((String)this.getValue()).toUpperCase();
        }
    }

    public static class InternalDataFactory {
        private static final InternalDataFactory instance = new InternalDataFactory();

        public static InternalDataFactory get() {
            return instance;
        }

        public InternalData createInternalData(ParameterHolder ph) {
            if (String.class.isAssignableFrom(ph.getType())) {
                return new StringData(ph.getRequestId(), ph.getParmName(), (String)ph.getValue());
            }
            if (Double.class.isAssignableFrom(ph.getType())) {
                return new DoubleData(ph.getRequestId(), ph.getParmName(), (Double)ph.getValue());
            }
            if (Boolean.class.isAssignableFrom(ph.getType())) {
                return new BooleanData(ph.getRequestId(), ph.getParmName(), (Boolean)ph.getValue());
            }
            return null;
        }
    }

    public static class InternalData<T> {
        private String requestId;
        private String name;
        private T value;
        private Class<T> type;

        protected InternalData(String requestId, String name, T value, Class<T> type) {
            this.requestId = requestId;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public Class<T> getType() {
            return this.type;
        }

        public void setType(Class<T> type) {
            this.type = type;
        }

        public String getCapitalizedName() {
            return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }

        public T getTransformed() {
            return null;
        }
    }

    public static class NamedVarsUnit
    implements RuleUnit {
        @UnitVar(value="minAge")
        private int adultAge = 0;
        @UnitVar(value="data")
        private DataSource<Person> persons;

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public int getAdultAge() {
            return this.adultAge;
        }
    }

    public static class ReactiveNotAdultUnit
    implements RuleUnit {
        private final DataSource<Person> persons;

        public ReactiveNotAdultUnit(DataSource<Person> persons) {
            this.persons = persons;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }
    }

    public static class ReactiveAdultUnit
    implements RuleUnit {
        private final DataSource<Person> persons;
        private final List<String> list;

        public ReactiveAdultUnit(DataSource<Person> persons, List<String> list) {
            this.persons = persons;
            this.list = list;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public List<String> getList() {
            return this.list;
        }

        public void onStart() {
            System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " started.");
        }

        public void onEnd() {
            System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " ended.");
        }

        public void onSuspend() {
            System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " suspended.");
        }

        public void onResume() {
            System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " resumed.");
        }
    }

    public static class NotAdultUnit
    implements RuleUnit {
        private DataSource<Person> persons;
        private List<String> log;

        public NotAdultUnit() {
        }

        public NotAdultUnit(DataSource<Person> persons) {
            this.persons = persons;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public void onStart() {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " started.");
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " started.");
            }
        }

        public void onEnd() {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " ended.");
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " ended.");
            }
        }

        public void onYield(RuleUnit other) {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " yielded to " + RuleUnitUtil.getUnitName((RuleUnit)other));
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " yielded to " + RuleUnitUtil.getUnitName((RuleUnit)other));
            }
        }
    }

    public static class AdultUnit
    implements RuleUnit {
        private int adultAge = 0;
        private DataSource<Person> persons;
        private List<String> log;
        private List<String> results;

        public AdultUnit() {
        }

        public AdultUnit(DataSource<Person> persons) {
            this.persons = persons;
        }

        public DataSource<Person> getPersons() {
            return this.persons;
        }

        public int getAdultAge() {
            return this.adultAge;
        }

        public List<String> getResults() {
            return this.results;
        }

        public void onStart() {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " started.");
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " started.");
            }
        }

        public void onEnd() {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " ended.");
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " ended.");
            }
        }

        public void onYield(RuleUnit other) {
            if (this.log != null) {
                this.log.add(RuleUnitUtil.getUnitName((RuleUnit)this) + " yielded to " + RuleUnitUtil.getUnitName((RuleUnit)other));
            } else {
                System.out.println(RuleUnitUtil.getUnitName((RuleUnit)this) + " yielded to " + RuleUnitUtil.getUnitName((RuleUnit)other));
            }
        }
    }
}

