/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.drools.testcoverage.common.model.A;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.MultithreadEvaluationOption;
import org.kie.internal.utils.KieHelper;

public class CompositeAgendaTest {
    @Test
    @Ignore
    public void testInALoop() {
        for (int i = 0; i < 100; ++i) {
            this.testCreateHaltDisposeAgenda();
            System.out.println("Done: " + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testCreateHaltDisposeAgenda() {
        String drl = " import " + A.class.getCanonicalName() + ";\n declare A @role( event ) end\n global java.util.concurrent.atomic.LongAdder firings;\n rule R0 when\n     A( value > 0,$Aid: id )\n then\n     firings.add(1);\n end\n rule R1 when\n     A(value > 1)\n then\n     firings.add(1);\n end\n rule R2 when\n     A(value > 2)\n then\n     firings.add(1);\n end\n rule R3 when\n     A(value > 3)\n then\n     firings.add(1);\n end\n rule R4 when\n     A(value > 4)\n then\n     firings.add(1);\n end\n rule R5 when\n     A(value > 5)\n then\n     firings.add(1);\n end\n rule R6 when\n     A(value > 6)\n then\n     firings.add(1);\n end\n rule R7 when\n     A(value > 7)\n then\n     firings.add(1);\n end";
        KieBaseConfiguration kieBaseConfiguration = KieBaseTestConfiguration.STREAM_IDENTITY.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)MultithreadEvaluationOption.YES);
        KieBase kieBase = new KieHelper().addContent(drl, ResourceType.DRL).build(kieBaseConfiguration);
        KieSession kieSession = kieBase.newKieSession();
        LongAdder firingCounter = new LongAdder();
        kieSession.setGlobal("firings", (Object)firingCounter);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.submit(() -> ((KieSession)kieSession).fireUntilHalt());
        try {
            EventInsertThread eventInsertThread = new EventInsertThread(kieSession);
            executor.submit(eventInsertThread);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            eventInsertThread.setActive(false);
        }
        finally {
            kieSession.halt();
            kieSession.dispose();
            executor.shutdown();
            try {
                if (!executor.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    public static class EventInsertThread
    implements Runnable {
        private boolean active = true;
        private KieSession kieSession;

        public EventInsertThread(KieSession kieSession) {
            this.kieSession = kieSession;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void run() {
            while (this.active) {
                this.kieSession.insert((Object)new A(100));
            }
        }
    }
}

