/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DRLCepTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DRLCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventsInDifferentPackages() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role( event )\nend\nrule r1\nwhen\nthen\n    StockTick st = new StockTick();\n    st.setCompany(\"RHT\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-cep-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }
}

