/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.integrationtests.BackwardChainingTest;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.SerializationHelper;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.Variable;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.internal.builder.conf.PropertySpecificOption;

@RunWith(value=Parameterized.class)
public class BackwardChainingUnsupportedModelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public BackwardChainingUnsupportedModelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithEvalAndTypeBoxingUnboxing() {
        String drl = "package org.drools.test;\n\nglobal java.util.List list \n;\nquery primitiveInt( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery boxedInteger( Integer $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery boxInteger( int $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery unboxInteger( Integer $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery cast( int $a )\n Integer( longValue == $a )\n eval( $a == 178 )\nend\nquery cast2( long $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nrule Init when then insert( 178 ); end\n\nrule Check\nwhen\n String()\n ?primitiveInt( 178 ; )\n ?boxedInteger( $x ; )\n ?boxInteger( $x ; )\n ?unboxInteger( $y ; )\n ?cast( $z ; )\n ?cast2( $z ; )\nthen\n list.add( $x ); \n list.add( $y ); \n list.add( $z ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test;\n\nglobal java.util.List list \n;\nquery primitiveInt( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery boxedInteger( Integer $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery boxInteger( int $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery unboxInteger( Integer $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery cast( int $a )\n Integer( longValue == $a )\n eval( $a == 178 )\nend\nquery cast2( long $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nrule Init when then insert( 178 ); end\n\nrule Check\nwhen\n String()\n ?primitiveInt( 178 ; )\n ?boxedInteger( $x ; )\n ?boxInteger( $x ; )\n ?unboxInteger( $y ; )\n ?cast( $z ; )\n ?cast2( $z ; )\nthen\n list.add( $x ); \n list.add( $y ); \n list.add( $z ); \nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertTrue((boolean)list.isEmpty());
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(178, 178, 178), list);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNaniSearchsNoPropReactivity() throws IOException, ClassNotFoundException {
        this.testNaniSearchs(PropertySpecificOption.ALLOWED);
    }

    @Test
    public void testNaniSearchsWithPropReactivity() throws IOException, ClassNotFoundException {
        this.testNaniSearchs(PropertySpecificOption.ALWAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNaniSearchs(PropertySpecificOption propertySpecificOption) throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and\n      Edible(x;) )      or \n     ( Location(z, y;) and ?whereFood(x, z;) )\nend\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits ) \n    Here(place;)\n    things := List() from accumulate( Location(thing, place;),\n                                      collectList( thing ) )\n    food := List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits := List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    Map map = new HashMap();    list.add(map);    map.put( 'place', place);     map.put( 'things', things);     map.put( 'food', food);     map.put( 'exits', exits);     System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"apple\", \"desk\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n";
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "backward-chaining-test", "1");
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", propertySpecificOption.toString());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{"package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and\n      Edible(x;) )      or \n     ( Location(z, y;) and ?whereFood(x, z;) )\nend\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits ) \n    Here(place;)\n    things := List() from accumulate( Location(thing, place;),\n                                      collectList( thing ) )\n    food := List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits := List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    Map map = new HashMap();    list.add(map);    map.put( 'place', place);     map.put( 'things', things);     map.put( 'food', food);     map.put( 'exits', exits);     System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"apple\", \"desk\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n"});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            ksession.insert((Object)"go1");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Map map = (Map)list.get(0);
            Assert.assertEquals((Object)"kitchen", map.get("place"));
            List items = (List)map.get("things");
            Assert.assertEquals((long)3L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple", "broccoli", "crackers"}, items);
            items = (List)map.get("food");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple", "crackers"}, items);
            items = (List)map.get("exits");
            Assert.assertEquals((long)3L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"office", "cellar", "dining room"}, items);
            ksession.insert((Object)"go2");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            map = (Map)list.get(1);
            Assert.assertEquals((Object)"office", map.get("place"));
            items = (List)map.get("things");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"computer", "desk"}, items);
            items = (List)map.get("food");
            Assert.assertEquals((long)1L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple"}, items);
            items = (List)map.get("exits");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"hall", "kitchen"}, items);
            QueryResults results = ksession.getQueryResults("isContainedIn", new Object[]{"key", "office"});
            Assert.assertEquals((long)1L, (long)results.size());
            QueryResultsRow result = (QueryResultsRow)results.iterator().next();
            Assert.assertEquals((Object)"key", (Object)result.get("x"));
            Assert.assertEquals((Object)"office", (Object)result.get("y"));
            results = ksession.getQueryResults("isContainedIn", new Object[]{"key", Variable.v});
            ArrayList<List<String>> l = new ArrayList<List<String>>();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)3L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("key", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "envelope"), l);
            results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, "office"});
            l = new ArrayList();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)6L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("desk", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("computer", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, Variable.v});
            l = new ArrayList();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)17L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("apple", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("desk", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("computer", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("washing machine", "cellar"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "envelope"), l);
            BackwardChainingTest.assertContains(Arrays.asList("broccoli", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("nani", "washing machine"), l);
            BackwardChainingTest.assertContains(Arrays.asList("crackers", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("nani", "cellar"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "desk"), l);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSubNetworksAndQueries() {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Edible\n   thing : String\nend\nquery whereFood( String x, String y ) \n    Location(x, y;) Edible(x;) \nend\n\nquery look(String place, List food ) \n    $s : String() // just here to give a OTN lookup point\n    food := List() from accumulate( whereFood(thing, place;) ,                                    collectList( thing ) )\n    exists( whereFood(thing, place;) )\n    not( whereFood(thing, place;) and\n          String( this == $s ) from thing )\nend\n\nrule init when\nthen\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Edible\n   thing : String\nend\nquery whereFood( String x, String y ) \n    Location(x, y;) Edible(x;) \nend\n\nquery look(String place, List food ) \n    $s : String() // just here to give a OTN lookup point\n    food := List() from accumulate( whereFood(thing, place;) ,                                    collectList( thing ) )\n    exists( whereFood(thing, place;) )\n    not( whereFood(thing, place;) and\n          String( this == $s ) from thing )\nend\n\nrule init when\nthen\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\nend\n"});
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != String.class) continue;
            node = n;
            break;
        }
        Assert.assertNotNull(node);
        BetaNode stringBetaNode = (BetaNode)node.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode1 = (QueryElementNode)stringBetaNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)queryElementNode1.getSinkPropagator().getSinks()[0];
        AccumulateNode accNode = (AccumulateNode)riaNode1.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode2 = (QueryElementNode)accNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)queryElementNode2.getSinkPropagator().getSinks()[0];
        ExistsNode existsNode = (ExistsNode)riaNode2.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode3 = (QueryElementNode)existsNode.getSinkPropagator().getSinks()[0];
        FromNode fromNode = (FromNode)queryElementNode3.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode3 = (RightInputAdapterNode)fromNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)riaNode3.getObjectSinkPropagator().getSinks()[0];
        KieSession ksession = kbase.newKieSession();
        try {
            StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)ksession;
            AccumulateNode.AccumulateMemory accMemory = (AccumulateNode.AccumulateMemory)wm.getNodeMemory((MemoryFactory)accNode);
            BetaMemory existsMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode);
            FromNode.FromMemory fromMemory = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)fromNode);
            BetaMemory notMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)notNode);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            FactHandle fh = ksession.insert((Object)"bread");
            ksession.fireAllRules();
            final ArrayList food = new ArrayList();
            QueryResults results = ksession.getQueryResults("look", new Object[]{"kitchen", Variable.v});
            Assert.assertEquals((long)1L, (long)results.size());
            for (QueryResultsRow row : results) {
                food.addAll((Collection)row.get("food"));
            }
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)0L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            final ArrayList foodUpdated = new ArrayList();
            LiveQuery query = ksession.openLiveQuery("look", new Object[]{"kitchen", Variable.v}, new ViewChangedEventListener(){

                public void rowUpdated(Row row) {
                    foodUpdated.addAll((Collection)row.get("food"));
                }

                public void rowDeleted(Row row) {
                }

                public void rowInserted(Row row) {
                    food.addAll((Collection)row.get("food"));
                }
            });
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            results = ksession.getQueryResults("look", new Object[]{"kitchen", Variable.v});
            Assert.assertEquals((long)1L, (long)results.size());
            for (QueryResultsRow row : results) {
                food.addAll((Collection)row.get("food"));
            }
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            ksession.update(fh, (Object)"crackers");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)1L, (long)notMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)foodUpdated.size());
            ksession.update(fh, (Object)"oranges");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            query.close();
            Assert.assertEquals((long)0L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testInsertionOrderTwo() {
        Object o;
        ArrayList list;
        int i;
        StringBuilder drlBuilder = new StringBuilder("package org.drools.compiler.test \nimport java.util.List \nglobal List list \ndeclare Thing \n    thing : String @key \nend \ndeclare Edible extends Thing \nend \ndeclare Location extends Thing \n    location : String  @key \nend \ndeclare Here \n    place : String \nend \nrule kickOff \nwhen \n    Integer( $i: intValue ) \nthen \n    switch( $i ){ \n");
        String[] facts = new String[]{"new Edible( 'peach' )", "new Location( 'peach', 'table' )", "new Here( 'table' )"};
        int f = 0;
        for (String fact : facts) {
            for (String fact1 : facts) {
                for (String fact2 : facts) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(fact);
                    set.add(fact1);
                    set.add(fact2);
                    if (set.size() != 3) continue;
                    drlBuilder.append("    case ").append(f++).append(": \n").append("        insert( ").append(fact).append(" ); \n").append("        insert( ").append(fact1).append(" ); \n").append("        insert( ").append(fact2).append(" ); \n").append("        break; \n");
                }
            }
        }
        facts = new String[]{"new Edible( 'peach' )", "new Location( 'table', 'office' )", "new Location( 'peach', 'table' )", "new Here( 'office' )"};
        int h = f;
        for (String fact : facts) {
            for (String fact1 : facts) {
                for (String fact3 : facts) {
                    for (String fact2 : facts) {
                        HashSet<String> set = new HashSet<String>();
                        set.add(fact);
                        set.add(fact1);
                        set.add(fact3);
                        set.add(fact2);
                        if (set.size() != 4) continue;
                        drlBuilder.append("    case ").append(h++).append(": \n").append("        insert( ").append(fact).append(" ); \n").append("        insert( ").append(fact1).append(" ); \n").append("        insert( ").append(fact3).append(" ); \n").append("        insert( ").append(fact2).append(" ); \n").append("        break; \n");
                    }
                }
            }
        }
        drlBuilder.append("    } \nend \n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and \n    Edible(x;) ) \n     or  \n    ( Location(z, y;) and whereFood(x, z;) ) \nend query look(String place, List things, List food)  \n    Here(place;) \n    things := List() from accumulate( Location(thing, place;), \n                                      collectList( thing ) ) \n    food := List() from accumulate( whereFood(thing, place;), \n                                    collectList( thing ) ) \nend \nrule reactiveLook \nwhen \n    Here( $place : place)  \n    look($place, $things; $food := food) \nthen \n    list.addAll( $things ); \n    list.addAll( $food   ); \nend \n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlBuilder.toString()});
        for (i = 0; i < f; ++i) {
            KieSession ksession = kbase.newKieSession();
            try {
                list = new ArrayList();
                ksession.setGlobal("list", list);
                ksession.fireAllRules();
                list.clear();
                InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)i);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertEquals((Object)"peach", list.get(0));
                Assert.assertEquals((Object)"peach", list.get(1));
                list.clear();
                InternalFactHandle[] handles = ksession.getFactHandles().toArray(new InternalFactHandle[0]);
                for (int j = 0; j < handles.length; ++j) {
                    if (handles[j].getObject() instanceof InitialFact || handles[j].getObject() instanceof Integer) continue;
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    o = handles[j].getObject();
                    ksession.delete((FactHandle)handles[j]);
                    handles[j] = (InternalFactHandle)ksession.insert(o);
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"peach", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    ksession.update((FactHandle)handles[j], handles[j].getObject());
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"peach", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                }
                fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
                ksession.delete((FactHandle)fh);
                continue;
            }
            finally {
                ksession.dispose();
            }
        }
        for (i = f; i < h; ++i) {
            KieSession ksession = kbase.newKieSession();
            try {
                list = new ArrayList();
                ksession.setGlobal("list", list);
                ksession.fireAllRules();
                list.clear();
                InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)i);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertEquals((Object)"table", list.get(0));
                Assert.assertEquals((Object)"peach", list.get(1));
                list.clear();
                InternalFactHandle[] handles = ksession.getFactHandles().toArray(new InternalFactHandle[0]);
                for (int j = 0; j < handles.length; ++j) {
                    if (handles[j].getObject() instanceof InitialFact || handles[j].getObject() instanceof Integer) continue;
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    o = handles[j].getObject();
                    ksession.delete((FactHandle)handles[j]);
                    handles[j] = (InternalFactHandle)ksession.insert(o);
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"table", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    ksession.update((FactHandle)handles[j], handles[j].getObject());
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"table", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                }
                fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
                ksession.delete((FactHandle)fh);
                continue;
            }
            finally {
                ksession.dispose();
            }
        }
    }
}

