/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.drools.core.io.impl.FileSystemResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class ChangesetUndoTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final File[] resources = new File[5];
    private static final String drl1 = "package org.drools.test1; declare Foo id : int end \nrule A when then end \n";
    private static final String drl2 = "package org.drools.test2; declare Foo2 id : Missing end \nrule A when then end \n";
    private static final String drl3 = "package org.drools.test3; declare Bar id : int end \nrule A when end \n";

    private String getChangeset(boolean excludeCorrectOne) {
        return "<change-set xmlns='http://drools.org/drools-5.0/change-set'\n            xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'\n            xs:schemaLocation='http://drools.org/drools-5.0/change-set https://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >\n            \n    <add >\n" + (excludeCorrectOne ? "" : "      <resource source='file:" + this.folder.getRoot().getAbsolutePath() + "/file1.drl' type='DRL' />\n ") + "      <resource source='file:" + this.folder.getRoot().getAbsolutePath() + "/file2.drl' type='DRL' />\n      <resource source='file:" + this.folder.getRoot().getAbsolutePath() + "/file3.drl' type='DRL' />\n    </add>\n    \n</change-set>\n";
    }

    @Before
    public void setup() {
        try {
            ChangesetUndoTest.resources[0] = this.folder.newFile("changeset1.xml");
            ChangesetUndoTest.resources[1] = this.folder.newFile("file1.drl");
            ChangesetUndoTest.resources[2] = this.folder.newFile("file2.drl");
            ChangesetUndoTest.resources[3] = this.folder.newFile("file3.drl");
            ChangesetUndoTest.resources[4] = this.folder.newFile("changeset2.xml");
            FileOutputStream fos0 = new FileOutputStream(resources[0]);
            fos0.write(this.getChangeset(false).getBytes());
            fos0.flush();
            fos0.close();
            FileOutputStream fos1 = new FileOutputStream(resources[1]);
            fos1.write(drl1.getBytes());
            fos1.flush();
            fos1.close();
            FileOutputStream fos2 = new FileOutputStream(resources[2]);
            fos2.write(drl2.getBytes());
            fos2.flush();
            fos2.close();
            FileOutputStream fos3 = new FileOutputStream(resources[3]);
            fos3.write(drl3.getBytes());
            fos3.flush();
            fos3.close();
            FileOutputStream fos4 = new FileOutputStream(resources[4]);
            fos4.write(this.getChangeset(true).getBytes());
            fos4.flush();
            fos4.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Assert.fail((String)ioe.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.folder.delete();
    }

    @Test
    public void testCompilationUndo() {
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new FileSystemResource(resources[0]), ResourceType.CHANGE_SET);
        Assert.assertTrue((boolean)knowledgeBuilder.hasErrors());
        knowledgeBuilder.undo();
        Assert.assertFalse((boolean)knowledgeBuilder.hasErrors());
        for (KiePackage kp : knowledgeBuilder.getKnowledgePackages()) {
            Assert.assertTrue((boolean)kp.getRules().isEmpty());
            Assert.assertTrue((boolean)kp.getFactTypes().isEmpty());
        }
    }

    @Test
    public void testCompilationUndoAfterGoodResults() {
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new FileSystemResource(resources[1]), ResourceType.DRL);
        knowledgeBuilder.add((Resource)new FileSystemResource(resources[4]), ResourceType.CHANGE_SET);
        Assert.assertTrue((boolean)knowledgeBuilder.hasErrors());
        knowledgeBuilder.undo();
        Assert.assertFalse((boolean)knowledgeBuilder.hasErrors());
        for (KiePackage kp : knowledgeBuilder.getKnowledgePackages()) {
            if ("org.drools.test1".equals(kp.getName())) {
                Assert.assertEquals((long)1L, (long)kp.getRules().size());
                Assert.assertEquals((long)1L, (long)kp.getFactTypes().size());
                continue;
            }
            Assert.assertTrue((boolean)kp.getRules().isEmpty());
            Assert.assertTrue((boolean)kp.getFactTypes().isEmpty());
        }
    }
}

