/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.incrementalcompilation.StringPermutation;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.test.testcategory.TurtleTestCategory;

@Category(value={TurtleTestCategory.class})
@RunWith(value=Parameterized.class)
public class AddRemoveRulesAddDeleteFactsTest {
    private final StringPermutation rulesPermutation;

    public AddRemoveRulesAddDeleteFactsTest(StringPermutation rulesPermutation) {
        this.rulesPermutation = rulesPermutation;
    }

    @Parameterized.Parameters
    public static Collection<StringPermutation[]> getRulesPermutations() {
        HashSet<StringPermutation[]> rulesPermutations = new HashSet<StringPermutation[]>();
        HashSet<StringPermutation> parametersPermutations = new HashSet<StringPermutation>();
        AddRemoveRulesAddDeleteFactsTest.getStringPermutations(new String[]{"R1", "R2", "R3"}, new String[0], parametersPermutations);
        for (StringPermutation permutation : parametersPermutations) {
            rulesPermutations.add(new StringPermutation[]{permutation});
        }
        return rulesPermutations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveRulesAddRemoveFacts() {
        KieSession kieSession = TestUtil.buildSessionInSteps(AddRemoveRulesAddDeleteFactsTest.getRules());
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            List<FactHandle> insertedFacts = TestUtil.insertFacts(kieSession, this.getFacts());
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2", "R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", this.rulesPermutation.getPermutation());
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.removeFacts(kieSession, insertedFacts);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    private Object[] getFacts() {
        return new Object[]{1, "1"};
    }

    private static void getStringPermutations(String[] rules, String[] partialPermutation, Collection<StringPermutation> foundPermutations) {
        if (rules.length == 1) {
            if (partialPermutation != null && partialPermutation.length > 0) {
                foundPermutations.add(new StringPermutation(AddRemoveRulesAddDeleteFactsTest.concatenateStringArrays(partialPermutation, rules)));
            } else {
                foundPermutations.add(new StringPermutation(rules));
            }
        } else {
            for (int i = 0; i < rules.length; ++i) {
                if (i == 0) {
                    AddRemoveRulesAddDeleteFactsTest.getStringPermutations(Arrays.copyOfRange(rules, 1, rules.length), AddRemoveRulesAddDeleteFactsTest.concatenateStringArrays(partialPermutation, new String[]{rules[i]}), foundPermutations);
                    continue;
                }
                if (i == rules.length - 1) {
                    AddRemoveRulesAddDeleteFactsTest.getStringPermutations(Arrays.copyOfRange(rules, 0, rules.length - 1), AddRemoveRulesAddDeleteFactsTest.concatenateStringArrays(partialPermutation, new String[]{rules[i]}), foundPermutations);
                    continue;
                }
                String[] remainingRules = AddRemoveRulesAddDeleteFactsTest.concatenateStringArrays(Arrays.copyOfRange(rules, 0, i), Arrays.copyOfRange(rules, i + 1, rules.length));
                AddRemoveRulesAddDeleteFactsTest.getStringPermutations(remainingRules, AddRemoveRulesAddDeleteFactsTest.concatenateStringArrays(partialPermutation, new String[]{rules[i]}), foundPermutations);
            }
        }
    }

    private static String[] concatenateStringArrays(String[] array1, String[] array2) {
        String[] concatenatedArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, concatenatedArray, 0, array1.length);
        System.arraycopy(array2, 0, concatenatedArray, array1.length, array2.length);
        return concatenatedArray;
    }

    private static String[] getRules() {
        String[] rules = new String[]{" package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end", " package com.rules;\n global java.util.List list\n rule R3 \n when \n   Integer() \n   exists(Integer() and Integer()) \n   String() \n then\n   list.add('R3'); \n end"};
        return rules;
    }
}

