/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class MathTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MathTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddition() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nglobal java.lang.Integer two;\n\nrule \"returnvalue rule test\"\n    when\n        $person1: Person( $age1 : age )\n        // We have no autoboxing of primtives, so have to do by hand\n        person2: Person( age == ( $age1 + two.intValue() ) )\n    then\n        list.add( $person1 );\n        list.add( person2 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"math-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("two", (Object)2);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person peter = new Person("peter", null, 12);
            ksession.insert((Object)peter);
            Person jane = new Person("jane", null, 10);
            ksession.insert((Object)jane);
            ksession.fireAllRules();
            Assert.assertEquals((Object)jane, ((List)ksession.getGlobal("list")).get(0));
            Assert.assertEquals((Object)peter, ((List)ksession.getGlobal("list")).get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNumberComparisons() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + RandomNumber.class.getCanonicalName() + ";\nimport " + Guess.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule High\n   when \n      RandomNumber(randomValue:value)\n      // literal constraint\n      Guess(guess: value > 10)\n   then \n      results.add(\"LOWER\");\nend\n\nrule Low\n   when \n      RandomNumber(randomValue:value)\n      // return value constraint\n      Guess(guess: value < ( 10 ) )\n   then \n      results.add(\"HIGHER\");\nend\n\nrule Win\n   when \n      RandomNumber(randomValue:value)\n      // variable constraint\n      Guess(value==randomValue)\n   then \n      results.add(\"CORRECT\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"math-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            RandomNumber rn = new RandomNumber();
            rn.setValue(10);
            ksession.insert((Object)rn);
            Guess guess = new Guess();
            guess.setValue(5);
            FactHandle handle = ksession.insert((Object)guess);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"HIGHER", list.get(0));
            guess.setValue(15);
            ksession.update(handle, (Object)guess);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"LOWER", list.get(1));
            guess.setValue(10);
            ksession.update(handle, (Object)guess);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((Object)"CORRECT", list.get(2));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShiftOperator() {
        String drl = "dialect \"mvel\"\nrule kickOff\nwhen\nthen\n   insert( Integer.valueOf( 1 ) );\n   insert( Long.valueOf( 1 ) );\n   insert( Integer.valueOf( 65552 ) ); // 0x10010\n   insert( Long.valueOf( 65552 ) );\n   insert( Integer.valueOf( 65568 ) ); // 0x10020\n   insert( Long.valueOf( 65568 ) );\n   insert( Integer.valueOf( 65536 ) ); // 0x10000\n   insert( Long.valueOf( 65536L ) );\n   insert( Long.valueOf( 4294967296L ) ); // 0x100000000L\nend\nrule test1\n   salience -1\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test1 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test2\n   salience -2\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test2 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test3\n   salience -3\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test3 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test4\n   salience -4\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test4 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"math-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"dialect \"mvel\"\nrule kickOff\nwhen\nthen\n   insert( Integer.valueOf( 1 ) );\n   insert( Long.valueOf( 1 ) );\n   insert( Integer.valueOf( 65552 ) ); // 0x10010\n   insert( Long.valueOf( 65552 ) );\n   insert( Integer.valueOf( 65568 ) ); // 0x10020\n   insert( Long.valueOf( 65568 ) );\n   insert( Integer.valueOf( 65536 ) ); // 0x10000\n   insert( Long.valueOf( 65536L ) );\n   insert( Long.valueOf( 4294967296L ) ); // 0x100000000L\nend\nrule test1\n   salience -1\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test1 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test2\n   salience -2\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test2 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test3\n   salience -3\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test3 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test4\n   salience -4\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test4 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)13L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    public class Guess
    implements Serializable {
        private Integer value;

        public void setValue(Integer guess) {
            this.value = guess;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static class RandomNumber {
        private int randomNumber;

        public void begin() {
            this.randomNumber = new Random().nextInt(100);
        }

        public void setValue(int value) {
            this.randomNumber = value;
        }

        public int getValue() {
            return this.randomNumber;
        }
    }
}

