/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.integrationtests.CepEspTest;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class CepEspNegativeCloudTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CepEspNegativeCloudTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCloudModeExpiration() throws InstantiationException, IllegalAccessException, InterruptedException {
        String drl = "package org.drools.cloud\nimport " + StockTick.class.getCanonicalName() + "\ndeclare Event\n        @role ( event )\n        name : String\n        value : Object\nend\ndeclare AnotherEvent\n        @role ( event )\n        message : String\n        type : String\nend\ndeclare StockTick\n        @role ( event )\nend\nrule \"two events\"\n    when\n        Event( value != null ) from entry-point X\n        StockTick( company != null ) from entry-point X\n    then\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            EntryPoint ep = ksession.getEntryPoint("X");
            ep.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            int rulesFired = ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)rulesFired);
            FactType event = kbase.getFactType("org.drools.cloud", "Event");
            Object e1 = event.newInstance();
            event.set(e1, "name", (Object)"someKey");
            event.set(e1, "value", (Object)"someValue");
            ep.insert(e1);
            rulesFired = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rulesFired);
            Thread.sleep(1000L);
            Assert.assertEquals((long)2L, (long)ep.getFactCount());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testThrowsWhenCreatingKieBaseUsingWindowsInCloudMode() {
        String drl = "declare TestEvent\n    @role( event )\n    name : String\nend\n\nrule R when\n        TestEvent ( name == \"EventA\" ) over window:time( 1s ) from entry-point EventStream\n    then\n        // consequence\nend\n";
        try {
            KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare TestEvent\n    @role( event )\n    name : String\nend\n\nrule R when\n        TestEvent ( name == \"EventA\" ) over window:time( 1s ) from entry-point EventStream\n    then\n        // consequence\nend\n"});
            Assert.fail((String)"Should throw a RuntimeException because the CLOUD kbase is trying to use features only available in STREAM mode");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporalQuery() {
        String drl = "package org.drools.compiler.integrationtests;\n\nimport " + CepEspTest.TestEvent.class.getCanonicalName() + ";\n\ndeclare TestEvent\n    @role( event )\nend\n\nquery EventsBeforeNineSeconds\n   $event : TestEvent() from entry-point EStream\n   $result : TestEvent ( this after [0s, 9s] $event) from entry-point EventStream\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            EntryPoint ePoint = ksession.getEntryPoint("EStream");
            EntryPoint entryPoint = ksession.getEntryPoint("EventStream");
            ePoint.insert((Object)new CepEspTest.TestEvent("zero"));
            entryPoint.insert((Object)new CepEspTest.TestEvent("one"));
            clock.advanceTime(10L, TimeUnit.SECONDS);
            entryPoint.insert((Object)new CepEspTest.TestEvent("two"));
            clock.advanceTime(10L, TimeUnit.SECONDS);
            entryPoint.insert((Object)new CepEspTest.TestEvent("three"));
            QueryResults results = ksession.getQueryResults("EventsBeforeNineSeconds", new Object[0]);
            Assert.assertEquals((long)1L, (long)results.size());
        }
        finally {
            ksession.dispose();
        }
    }
}

