/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.Collection;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ForAllTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ForAllTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test1P1CFiring1() {
        this.check("age >= 18", 1, new Person("Mario", 45));
    }

    @Test
    public void test1P1CFiring2() {
        this.check("age == 8 || == 45", 1, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiring() {
        this.check("age >= 18", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P2CFiring() {
        this.check("age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43));
    }

    @Test
    public void test1P2CNotFiring1() {
        this.check("age >= 18, name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Mark", 43), new Person("Edson", 40));
    }

    @Test
    public void test1P2CNotFiring2() {
        this.check("age < 18, name.startsWith(\"M\")", 0, new Person("Sofia", 8));
    }

    @Test
    public void test2P1CFiring() {
        this.check("age >= 18", "name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test2P1CNotFiring() {
        this.check("age >= 1", "name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test2P2CFiring() {
        this.check("", "age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43));
    }

    @Test
    public void test2P2CNotFiring1() {
        this.check("", "age >= 18, name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Mark", 43), new Person("Edson", 40));
    }

    @Test
    public void test2P3CFiring() {
        this.check("name.length() < 6", "age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43), new Person("Daniele", 43));
    }

    private void check(String constraints1, int expectedFires, Object ... objs) {
        this.check(constraints1, null, expectedFires, objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String constraints1, String constraints2, int expectedFires, Object ... objs) {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\n\nrule R1 when\n    forall(\n       $p: Person( " + constraints1 + " )\n" + (constraints2 != null ? "       Person( this == $p," + constraints2 + " )\n" : "") + "    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            for (Object obj : objs) {
                ksession.insert(obj);
            }
            Assert.assertEquals((long)expectedFires, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }
}

