/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ContainsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ContainsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsCheese() {
        String drl = "package org.drools.compiler.integrationtests.operators;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Cheesery contains stilton\"\n    salience 10\n    when\n        stilton : Cheese( type == \"stilton\" )\n        Cheesery( cheeses contains stilton )\n    then\n        list.add( stilton );\nend   \n\nrule \"Cheesery does not contain brie\"\n    when\n        brie : Cheese( type == \"brie\" )\n        Cheesery( cheeses not contains brie )\n    then\n        list.add( brie );\nend ";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"contains-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 12);
            ksession.insert((Object)stilton);
            Cheese brie = new Cheese("brie", 10);
            ksession.insert((Object)brie);
            Cheesery cheesery = new Cheesery();
            cheesery.getCheeses().add(stilton);
            ksession.insert((Object)cheesery);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)stilton, list.get(0));
            Assert.assertEquals((Object)brie, list.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsInArray() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + Primitives.class.getCanonicalName() + " ;\nglobal java.util.List list;\n\nrule \"contains in elements\"\n    salience 10\n    when\n        Primitives( stringArray contains \"test1\" )\n    then\n        list.add( \"ok1\" );\nend\n\nrule \"excludes in elements\"\n    when\n        Primitives( stringArray excludes \"test2\" )\n    then\n        list.add( \"ok2\" );\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"contains-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Primitives p = new Primitives();
            p.setStringArray(new String[]{"test1", "test3"});
            ksession.insert((Object)p);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"ok1", list.get(0));
            Assert.assertEquals((Object)"ok2", list.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsOperator() {
        String str = "package org.drools.compiler.integrationtests.operators\nimport " + Order.class.getCanonicalName() + " ;\nimport " + OrderItem.class.getCanonicalName() + " ;\nrule NotContains\nwhen\n    $oi : OrderItem( )\n    $o  : Order( items.values() not contains $oi )then\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"contains-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kieBase.newKieSession();
        try {
            Order order1 = new Order(1, "XYZ");
            Order order2 = new Order(2, "ABC");
            OrderItem item11 = new OrderItem(order1, 1);
            order1.addItem(item11);
            OrderItem item21 = new OrderItem(order2, 1);
            order2.addItem(item21);
            ksession.insert((Object)order1);
            ksession.insert((Object)item11);
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)rules);
            ksession.insert((Object)item21);
            rules = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }
}

