/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.A;
import org.drools.testcoverage.common.model.B;
import org.drools.testcoverage.common.model.C;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.D;
import org.drools.testcoverage.common.model.E;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DRLTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DRLTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDuplicateRuleName() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nrule R when\nthen\nend\nrule R when\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nrule R when\nthen\nend\nrule R when\nthen\nend\n"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyRule() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\nrule \"empty lhs1\"\n    when\n    then\n        list.add(\"fired1\");\nend    \nrule \"empty lhs2\"\n    when\n    then\n        list.add(\"fired2\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\nrule \"empty lhs1\"\n    when\n    then\n        list.add(\"fired1\");\nend    \nrule \"empty lhs2\"\n    when\n    then\n        list.add(\"fired2\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertTrue((boolean)list.contains("fired1"));
            Assert.assertTrue((boolean)list.contains("fired2"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleMetaAttributes() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nrule \"test meta attributes\"\n    @id(1234 ) @author(  john_doe  ) @text(\"It's an escaped\\\" string\"  )\nwhen\nthen\n    // some comment\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nrule \"test meta attributes\"\n    @id(1234 ) @author(  john_doe  ) @text(\"It's an escaped\\\" string\"  )\nwhen\nthen\n    // some comment\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            Rule rule = kbase.getRule("org.drools.compiler.integrationtests.drl", "test meta attributes");
            Assert.assertNotNull((Object)rule);
            Assert.assertThat(rule.getMetaData().get("id"), (Matcher)CoreMatchers.is((Object)1234));
            Assert.assertThat(rule.getMetaData().get("author"), (Matcher)CoreMatchers.is((Object)"john_doe"));
            Assert.assertThat(rule.getMetaData().get("text"), (Matcher)CoreMatchers.is((Object)"It's an escaped\" string"));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testWithInvalidRule() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\n//error 1) missing a person import\n\n\nglobal java.util.List list;\n\nrule \"not rule test\"\n    when\n        // error 2) incorrect field\n        $person : Person( $likes:likeypooh )\n        not Cheese( type == $likes )\n    then\n        list.add( $person );\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    @Test
    public void testWithInvalidRule2() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\n\n\nrule \"not rule test\"\nwhen\n    foo\nthen\n    System.err.println(\"hey\");\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateVariableBinding() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.Map results;\n\nrule \"Duplicate Variable testing\"\n when\n   // there should be no problem since each variable \n   // is in a different logical branch\n   Cheese( $type : type == \"stilton\", $price : price ) or\n   Cheese( $type : type == \"brie\", $price : price )\n then\n   results.put( $type, new Integer( $price ) );\nend\n\nrule \"Duplicate Variable testing 2\"\n when\n   // there should be no problem since each variable \n   // is in a different logical branch\n   $cheese : Cheese( type == \"stilton\", $price : price ) or\n   $cheese : Cheese( type == \"brie\", $price : price )\n then\n   results.put( $cheese, new Integer( $price ) );\nend\n\nrule \"Duplicate Variable testing 3\"\n when\n   // there should be no problem since each variable \n   // is in a different logical branch\n   Cheese( $type : type == \"stilton\", $price : price ) or\n   ( Cheese( $type : type == \"brie\", $price : price ) and Person( name == \"bob\", likes == $type ) )\n then\n   results.put( \"test3\"+$type, new Integer( $price ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap result = new HashMap();
            ksession.setGlobal("results", result);
            Cheese stilton = new Cheese("stilton", 20);
            Cheese brie = new Cheese("brie", 10);
            ksession.insert((Object)stilton);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)5L, (long)result.size());
            Assert.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get(stilton.getType())).intValue());
            Assert.assertEquals((long)brie.getPrice(), (long)((Integer)result.get(brie.getType())).intValue());
            Assert.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get(stilton)).intValue());
            Assert.assertEquals((long)brie.getPrice(), (long)((Integer)result.get(brie)).intValue());
            Assert.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get("test3" + stilton.getType())).intValue());
            Person bob = new Person("bob");
            bob.setLikes(brie.getType());
            ksession.insert((Object)bob);
            ksession.fireAllRules();
            Assert.assertEquals((long)6L, (long)result.size());
            Assert.assertEquals((long)brie.getPrice(), (long)((Integer)result.get("test3" + brie.getType())).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testDeclarationUsage() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nrule \"test declaration\"\nwhen\n    Cheese( type == $likes )\n    Person( $likes : likes );\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    @Test
    public void testDeclarationNonExistingField() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule \"test declaration of non existing field\"\nwhen\n    Person( $likes : likes, $nef : nonExistingField )\n    Cheese( type == $likes ) \nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).doesNotContain((Object[])new String[]{""});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDRLWithoutPackageDeclaration() throws Exception {
        String drl = "global java.util.List results\n\nfunction boolean test( Object o1, Object o2 ) {\n    return o1.equals(o2);\n}\n\ndeclare Person\n    name : String @key\n    age : int\nend    \n\nrule \"TestRule\"\nwhen\n    $p : Person( name == \"Bob\" );\nthen\n    results.add( $p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List results\n\nfunction boolean test( Object o1, Object o2 ) {\n    return o1.equals(o2);\n}\n\ndeclare Person\n    name : String @key\n    age : int\nend    \n\nrule \"TestRule\"\nwhen\n    $p : Person( name == \"Bob\" );\nthen\n    results.add( $p );\nend"});
        FactType factType = kbase.getFactType("defaultpkg", "Person");
        Assert.assertNotNull((Object)factType);
        Object bob = factType.newInstance();
        factType.set(bob, "name", (Object)"Bob");
        factType.set(bob, "age", (Object)30);
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            session.insert(bob);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)bob, results.get(0));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageNameOfTheBeast() throws Exception {
        String ruleFileContent1 = "package org.drools.integrationtests;\nfunction void myFunction() {\n}\ndeclare MyDeclaredType\n  someProperty: boolean\nend";
        String ruleFileContent2 = "package de.something;\nimport org.drools.integrationtests.*;\nrule \"CheckMyDeclaredType\"\n  when\n    MyDeclaredType()\n  then\n    insertLogical(\"THIS-IS-MY-MARKER-STRING\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"drl-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.integrationtests;\nfunction void myFunction() {\n}\ndeclare MyDeclaredType\n  someProperty: boolean\nend", "package de.something;\nimport org.drools.integrationtests.*;\nrule \"CheckMyDeclaredType\"\n  when\n    MyDeclaredType()\n  then\n    insertLogical(\"THIS-IS-MY-MARKER-STRING\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType myDeclaredFactType = kbase.getFactType("org.drools.integrationtests", "MyDeclaredType");
            Object myDeclaredFactInstance = myDeclaredFactType.newInstance();
            ksession.insert(myDeclaredFactInstance);
            int rulesFired = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rulesFired);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testLargeDRL() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/largedrl.drl"});
        KieSession kieSession = kieBase.newKieSession();
        try {
            kieSession.insert((Object)new A(100000));
            kieSession.insert((Object)new B(100001));
            kieSession.insert((Object)new C(100002));
            kieSession.insert((Object)new D(100003));
            kieSession.insert((Object)new E(100004));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(50);
        }
        finally {
            kieSession.dispose();
        }
    }
}

