/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.drools.core.base.UndefinedCalendarExcption;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.util.DateUtils;
import org.drools.testcoverage.common.model.Alarm;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.FactA;
import org.drools.testcoverage.common.model.FactB;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.Calendar;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TimerAndCalendarTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void testDuration() throws Exception {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule delayed\n    duration 100\n    when\n        cheese : Cheese( )\n    then\n        list.add( cheese );\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese brie = new Cheese("brie", 12);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            Thread.sleep(500L);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDurationWithNoLoop() throws Exception {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule delayed\n    timer 100\n    no-loop true\n    when\n        cheese : Cheese( )\n    then\n        list.add( cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese brie = new Cheese("brie", 12);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            Thread.sleep(300L);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDurationMemoryLeakonRepeatedUpdate() {
        String drl = "package org.drools.compiler.test\nimport " + Alarm.class.getCanonicalName() + "\nglobal java.util.List list;rule \"COMPTEUR\"\n  timer (int: 50s)\n  when\n    $alarm : Alarm( number < 5 )\n  then\n    $alarm.incrementNumber();\n    list.add( $alarm );\n    update($alarm);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Alarm());
            ksession.fireAllRules();
            for (int i = 0; i < 6; ++i) {
                timeService.advanceTime(55L, TimeUnit.SECONDS);
                ksession.fireAllRules();
            }
            Assert.assertEquals((long)5L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFireRuleAfterDuration() throws Exception {
        String drl = "package org.drools.compiler.test;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule delayed\n    duration 100\n    when\n        cheese : Cheese( $type:type == \"brie\" )\n    then\n        list.add( cheese );\n        insert(new Cheese(\"stilton\", 42));\n        delete(cheese);\nend\n\nrule after_delayed\n    when\n        cheese : Cheese( $type:type == \"stilton\" )\n    then\n        list.add( cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese brie = new Cheese("brie", 12);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            Thread.sleep(300L);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testNoProtocolIntervalTimer() {
        this.testIntervalTimer(true);
    }

    @Test(timeout=10000L)
    public void testIntervalTimer() {
        this.testIntervalTimer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntervalTimer(boolean noProtocol) {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n" + (noProtocol ? "  duration (30s 10s) " : "  timer (int:30s 10s) ") + "when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerWithoutFire() {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (int:30s 10s) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (int:30s 10s) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(35L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testExprIntervalTimerRaceCondition() {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (expr: $i, $i) \nwhen \n   $i : Long() \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (expr: $i, $i) \nwhen \n   $i : Long() \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            FactHandle fh = ksession.insert((Object)10000L);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(17L, TimeUnit.SECONDS);
            ksession.update(fh, (Object)5000L);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testUnknownProtocol() {
        this.wrongTimerExpression("xyz:30");
    }

    @Test(timeout=10000L)
    public void testMissingColon() {
        this.wrongTimerExpression("int 30");
    }

    @Test(timeout=10000L)
    public void testMalformedExpression() {
        this.wrongTimerExpression("30s s30");
    }

    @Test(timeout=10000L)
    public void testMalformedIntExpression() {
        this.wrongTimerExpression("int 30s");
    }

    @Test(timeout=10000L)
    public void testMalformedCronExpression() {
        this.wrongTimerExpression("cron: 0/30 * * * * *");
    }

    private void wrongTimerExpression(String timer) {
        String drl = "package org.simple \nrule xxx \n  timer (" + timer + ") when \nthen \nend  \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCronTimer() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarNormalRuleSingleCalendar() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n";
        Calendar calFalse = timestamp -> false;
        Calendar calTrue = timestamp -> true;
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            ksession.getCalendars().set("cal1", calTrue);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.insert((Object)"o1");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o2");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            ksession.getCalendars().set("cal1", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o3");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            ksession.getCalendars().set("cal1", calTrue);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.insert((Object)"o4");
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndefinedCalendar() {
        String drl = "rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            try {
                ksession.fireAllRules();
                Assert.fail((String)"should throw UndefinedCalendarExcption");
            }
            catch (UndefinedCalendarExcption undefinedCalendarExcption) {
                // empty catch block
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarNormalRuleMultipleCalendars() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            Calendar calFalse = timestamp -> false;
            Calendar calTrue = timestamp -> true;
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            ksession.getCalendars().set("cal1", calTrue);
            ksession.getCalendars().set("cal2", calTrue);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.insert((Object)"o1");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            ksession.getCalendars().set("cal2", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o2");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            ksession.getCalendars().set("cal1", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o3");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            ksession.getCalendars().set("cal1", calTrue);
            ksession.getCalendars().set("cal2", calTrue);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.insert((Object)"o4");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCron() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            Date date1 = new Date(date.getTime() + 15000L);
            Date date2 = new Date(date1.getTime() + 60000L);
            Date date3 = new Date(date2.getTime() + 60000L);
            Date date4 = new Date(date3.getTime() + 60000L);
            Calendar cal1 = timestamp -> {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            };
            Calendar cal2 = timestamp -> {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            };
            ksession.getCalendars().set("cal1", cal1);
            ksession.getCalendars().set("cal2", cal2);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervals() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (15s 60s) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (15s 60s) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            Date date1 = new Date(date.getTime() + 15000L);
            Date date2 = new Date(date1.getTime() + 60000L);
            Date date3 = new Date(date2.getTime() + 60000L);
            Date date4 = new Date(date3.getTime() + 60000L);
            Calendar cal1 = timestamp -> {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            };
            Calendar cal2 = timestamp -> {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            };
            ksession.getCalendars().set("cal1", cal1);
            ksession.getCalendars().set("cal2", cal2);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervalsAndStartAndEnd() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, end=5-JAN-2010) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, end=5-JAN-2010) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
            Date date = df.parse("1-JAN-2010");
            Calendar cal1 = timestamp -> true;
            long oneDay = 86400L;
            ksession.getCalendars().set("cal1", cal1);
            ksession.setGlobal("list", list);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervalsAndStartAndLimit() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, repeat-limit=4) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, repeat-limit=4) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
            Date date = df.parse("1-JAN-2010");
            Calendar cal1 = timestamp -> true;
            long oneDay = 86400L;
            ksession.getCalendars().set("cal1", cal1);
            ksession.setGlobal("list", list);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCronAndStartAndEnd() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(Locale.UK);
            String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  date-expires \"6-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  date-expires \"6-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
            KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
            try {
                ArrayList list = new ArrayList();
                PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
                SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
                Date date = df.parse("1-JAN-2010");
                Calendar cal1 = timestamp -> true;
                long oneDay = 86400L;
                ksession.getCalendars().set("cal1", cal1);
                ksession.setGlobal("list", list);
                timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)0L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)0L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)1L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)3L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)3L, (long)list.size());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCronAndStartAndLimit() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(Locale.UK);
            String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?; repeat-limit=6) when \nthen \n  list.add(\"fired\"); \nend  \n";
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?; repeat-limit=6) when \nthen \n  list.add(\"fired\"); \nend  \n"});
            KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
            try {
                ArrayList list = new ArrayList();
                PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
                SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
                Date date = df.parse("1-JAN-2010");
                Calendar cal1 = timestamp -> true;
                long oneDay = 86400L;
                ksession.getCalendars().set("cal1", cal1);
                ksession.setGlobal("list", list);
                timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)0L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)0L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)1L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)3L, (long)list.size());
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assert.assertEquals((long)4L, (long)list.size());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    @Test(timeout=10000L)
    public void testTimerWithNot() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_Timer_With_Not.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.fireAllRules();
            Thread.sleep(200L);
            ksession.fireAllRules();
            Thread.sleep(200L);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testHaltWithTimer() throws Exception {
        String drl = "// fire once, for a String, create an Integer, halt!\nrule x\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"halt\" )\nthen\n    insert( new Integer(1) );\n    drools.halt();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"// fire once, for a String, create an Integer, halt!\nrule x\ntimer(int:0 1000)\nwhen\n    $s: String( this == \"halt\" )\nthen\n    insert( new Integer(1) );\n    drools.halt();\nend"});
        KieSession ksession = kbase.newKieSession();
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            Thread.sleep(1000L);
            FactHandle handle = ksession.insert((Object)"halt");
            Thread.sleep(2000L);
            Assert.assertEquals((long)2L, (long)ksession.getFactCount());
            ksession.delete(handle);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTimerRemoval() throws InterruptedException {
        String drl = "package org.drools.compiler.test\nimport " + TimeUnit.class.getName() + "\nglobal java.util.List list \nglobal " + CountDownLatch.class.getName() + " latch\nrule TimerRule \n   timer (int:100 50) \nwhen \nthen \n        //forces it to pause until main thread is ready\n        latch.await(10, TimeUnit.MINUTES); \n        list.add(list.size()); \n end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            List list = Collections.synchronizedList(new ArrayList());
            ksession.setGlobal("list", list);
            ksession.setGlobal("latch", (Object)latch);
            ksession.fireAllRules();
            Thread.sleep(500L);
            kbase.removeRule("org.drools.compiler.test", "TimerRule");
            ksession.fireAllRules();
            latch.countDown();
            Thread.sleep(500L);
            ksession.fireAllRules();
            list.clear();
            Thread.sleep(500L);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerWithLongExpressions() {
        String drl = "package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.setStartupTime(DateUtils.parseDate((String)"3-JAN-2010").getTime());
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithStringExpressions() {
        this.checkIntervalTimerWithStringExpressions(false, "3-JAN-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithAllExpressions() {
        this.checkIntervalTimerWithStringExpressions(true, "3-JAN-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithStringExpressionsAfterStart() {
        this.checkIntervalTimerWithStringExpressions(false, "3-FEB-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithAllExpressionsAfterStart() {
        this.checkIntervalTimerWithStringExpressions(true, "3-FEB-2010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIntervalTimerWithStringExpressions(boolean useExprForStart, String startTime) {
        String drl = "package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : String = \"30s\"\n  period  : long = 60000\n  start   : String = \"3-JAN-2010\"\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=" + (useExprForStart ? "$s" : "3-JAN-2010") + " )\nwhen\n  Bean( $d : delay, $p : period, $s : start )\nthen\n  list.add( \"fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.setStartupTime(DateUtils.parseDate((String)startTime).getTime());
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(40L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.setStartupTime(DateUtils.parseDate((String)"3-MAR-2010").getTime());
            list.clear();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(40L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerExpressionWithOr() {
        String drl = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nimport " + FactB.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nrule r1 timer (expr: f1.field2, f1.field2; repeat-limit=3)\nwhen\n    foo: FactB()\n    ( Pet()  and f1 : FactA( field1 == 'f1') ) or \n    f1 : FactA(field1 == 'f2') \nthen\n    list.add( f1 );\n    foo.setF1( 'xxx' );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new FactB());
            ksession.insert((Object)new Pet("cinchilla"));
            FactA fact1 = new FactA();
            fact1.setField1("f1");
            fact1.setField2(Integer.valueOf(250));
            FactA fact3 = new FactA();
            fact3.setField1("f2");
            fact3.setField2(Integer.valueOf(1000));
            ksession.insert((Object)fact1);
            ksession.insert((Object)fact3);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(0));
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(1));
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((Object)fact3, list.get(2));
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
            Assert.assertEquals((Object)fact3, list.get(3));
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testExprTimeRescheduled() {
        String drl = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nrule r1 timer (expr: f1.field2, f1.field4)\nwhen\n    f1 : FactA() \nthen\n    list.add( f1 );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            FactA fact1 = new FactA();
            fact1.setField1("f1");
            fact1.setField2(Integer.valueOf(500));
            fact1.setField4(Integer.valueOf(1000));
            FactHandle fh = ksession.insert((Object)fact1);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(1100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(0));
            timeService.advanceTime(1100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(1));
            timeService.advanceTime(400L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(2));
            list.clear();
            fact1.setField2(Integer.valueOf(300));
            fact1.setField4(Integer.valueOf(2000));
            ksession.update(fh, (Object)fact1);
            ksession.fireAllRules();
            timeService.advanceTime(1950L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)fact1, list.get(0));
            list.clear();
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(700L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    @Ignore
    public void testHaltAfterSomeTimeThenRestart() throws Exception {
        String drl = "package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\ntimer(int:0 100)\nwhen  \nthen \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\nrule Hi \nsalience 10 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( 5 ); \nend \n\nrule Lo \nsalience -5 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( -5 ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\ntimer(int:0 100)\nwhen  \nthen \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\nrule Hi \nsalience 10 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( 5 ); \nend \n\nrule Lo \nsalience -5 \nwhen \n  String( this == \"trigger\" ) \nthen \n   list.add( -5 ); \nend \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
            Thread.sleep(250L);
            Assert.assertEquals(Arrays.asList(0, 0, 0), list);
            ksession.insert((Object)"halt");
            ksession.insert((Object)"trigger");
            Thread.sleep(300L);
            Assert.assertEquals(Arrays.asList(0, 0, 0), list);
            new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
            Thread.sleep(200L);
            Assert.assertEquals(Arrays.asList(0, 0, 0, 5, 0, -5, 0, 0), list);
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testHaltAfterSomeTimeThenRestartButNoLongerHolding() throws Exception {
        String drl = "package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\n   timer(int:0 200)\nwhen  \n  eval(true)  String( this == \"trigger\" )then \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.kie.test;global java.util.List list; \n\n\nrule FireAtWill\n   timer(int:0 200)\nwhen  \n  eval(true)  String( this == \"trigger\" )then \n  list.add( 0 );\nend\n\nrule ImDone\nwhen\n  String( this == \"halt\" )\nthen\n  drools.halt();\nend\n\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle handle = ksession.insert((Object)"trigger");
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            Thread.sleep(350L);
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals(Arrays.asList(0, 0), list);
            ksession.insert((Object)"halt");
            Thread.sleep(200L);
            ksession.delete(handle);
            Assert.assertEquals((long)2L, (long)list.size());
            new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
            try {
                Thread.sleep(200L);
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertEquals(Arrays.asList(0, 0), list);
            }
            finally {
                ksession.halt();
            }
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiredPropagations() {
        String drl = "package org.drools.test;\n\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare StockTick\n    @role( event )\n    @timestamp( time )\nend\n\ndeclare window ATicks\n StockTick( company == \"AAA\" ) over window:time( 1s )  from entry-point \"AAA\"\nend\n\ndeclare window BTicks\n StockTick( company == \"BBB\" ) over window:time( 1s )  from entry-point \"BBB\"\nend\n\nrule Ticks \n when\n String()\n accumulate( $x : StockTick() from window ATicks, $a : count( $x ) )\n accumulate( $y : StockTick() from window BTicks, $b : count( $y ) )\n accumulate( $z : StockTick() over window:time( 1s ), $c : count( $z ) )\n then\n list.add( $a );\n list.add( $b );\n list.add( $c );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(1100L, TimeUnit.MILLISECONDS);
            StockTick tick = new StockTick(0L, "AAA", 1.0, 0L);
            StockTick tock = new StockTick(1L, "BBB", 1.0, 2500L);
            StockTick tack = new StockTick(1L, "CCC", 1.0, 2700L);
            EntryPoint epa = ksession.getEntryPoint("AAA");
            EntryPoint epb = ksession.getEntryPoint("BBB");
            epa.insert((Object)tick);
            epb.insert((Object)tock);
            ksession.insert((Object)tack);
            FactHandle handle = ksession.insert((Object)"go1");
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(0L, 1L, 1L), list);
            list.clear();
            ksession.delete(handle);
            clock.advanceTime(2550L, TimeUnit.MILLISECONDS);
            handle = ksession.insert((Object)"go2");
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(0L, 0L, 1L), list);
            list.clear();
            ksession.delete(handle);
            clock.advanceTime(500L, TimeUnit.MILLISECONDS);
            handle = ksession.insert((Object)"go3");
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(0L, 0L, 0L), list);
            list.clear();
            ksession.delete(handle);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCronFire() {
        String drl = "package test.drools\nrule TestRule   timer (cron:* * * * * ?) when\n    String()     Integer() then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package test.drools\nrule TestRule   timer (cron:* * * * * ?) when\n    String()     Integer() then\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            int repetitions = 10000;
            for (int j = 0; j < 10000; ++j) {
                ksession.insert((Object)j);
            }
            ksession.insert((Object)"go");
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    @Ignore(value="the listener callback holds some locks so blocking in it is not safe")
    public void testRaceConditionWithTimedRuleExectionOption() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx @Propagation(EAGER)\n  timer (int:30s 10s) when \n  $s: String()\nthen \n  list.add($s); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx @Propagation(EAGER)\n  timer (int:30s 10s) when \n  $s: String()\nthen \n  list.add($s); \nend  \n"});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            final CyclicBarrier barrier = new CyclicBarrier(2);
            final AtomicBoolean aBool = new AtomicBoolean(true);
            DefaultAgendaEventListener agendaEventListener = new DefaultAgendaEventListener(){

                public void afterMatchFired(AfterMatchFiredEvent event) {
                    try {
                        if (aBool.get()) {
                            barrier.await();
                            aBool.set(false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionClock clock = ksession.getSessionClock();
            SessionPseudoClock pseudoClock = (SessionPseudoClock)clock;
            String eventOne = "one";
            ksession.insert((Object)"one");
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            pseudoClock.advanceTime(30000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            String eventTwo = "two";
            ksession.insert((Object)"two");
            ksession.fireAllRules();
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            aBool.set(true);
            barrier.await();
            barrier.reset();
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            aBool.set(true);
            barrier.await();
            barrier.reset();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedTimers() {
        String drl = "package org.simple \nglobal java.util.List list \nrule R1\n  timer (int:30s 10s) when \n  $i: Integer()\nthen \n  list.add(\"1\"); \nend  \nrule R2\n  timer (int:30s 10s) when \n  $i: Integer()\nthen \n  list.add(\"2\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule R1\n  timer (int:30s 10s) when \n  $i: Integer()\nthen \n  list.add(\"1\"); \nend  \nrule R2\n  timer (int:30s 10s) when \n  $i: Integer()\nthen \n  list.add(\"2\"); \nend  \n"});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionClock clock = ksession.getSessionClock();
            SessionPseudoClock pseudoClock = (SessionPseudoClock)clock;
            ksession.insert((Object)1);
            ksession.fireAllRules();
            pseudoClock.advanceTime(35L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.containsAll(Arrays.asList("1", "2")));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntervalRuleInsertion() throws Exception {
        String drl = "package org.simple\nglobal java.util.List list\nimport " + Alarm.class.getCanonicalName() + "\nrule \"Interval Alarm\"\ntimer(int: 1s 1s)\nwhen     not Alarm()\nthen\n    insert(new Alarm());\n    list.add(\"fired\"); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            Thread.sleep(900L);
            Assert.assertEquals((long)0L, (long)list.size());
            Thread.sleep(500L);
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }
}

