/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.ConsequenceException;
import org.kie.api.runtime.rule.FactHandle;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class ConsequenceTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ConsequenceTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsequenceException() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nrule \"Throw Consequence Exception\"\n    when\n        cheese : Cheese( )\n    then\n        throw new Exception( \"this should throw an exception\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"consequence-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese brie = new Cheese("brie", 12);
            ksession.insert((Object)brie);
            try {
                ksession.fireAllRules();
                Assert.fail((String)"Should throw an Exception from the Consequence");
            }
            catch (ConsequenceException e) {
                Assert.assertEquals((Object)"Throw Consequence Exception", (Object)e.getMatch().getRule().getName());
                Assert.assertEquals((Object)"this should throw an exception", (Object)e.getCause().getMessage());
            }
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testConsequenceBuilderException() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List results;\nrule \"error compiling consequence\"\n    when\n    then\n        // this must generate a compile error, but not NPE\n        results.add(message without quotes);\nend\nrule \"another test\"\n    salience 10\n\n   when\n    eval( true ) \nthen\n    System.out.println(1);\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nglobal java.util.List results;\nrule \"error compiling consequence\"\n    when\n    then\n        // this must generate a compile error, but not NPE\n        results.add(message without quotes);\nend\nrule \"another test\"\n    salience 10\n\n   when\n    eval( true ) \nthen\n    System.out.println(1);\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaConsequence() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List results;\nimport " + Person.class.getCanonicalName() + ";\nrule \"Test Consequence\"\n    @foo(bar)\n    @foo2(bar2)\n    @ruleID(1234)\n    @parentRuleID(1234)\n    @dateActive(12/1/08)\n    @price(123.00)\n    @errorMSG(Stop)\n    @userMSG(\"Please Stop\")\n  when\n    Person(name == \"Michael\")\n  then\n    results.add( drools.getRule().getMetaData().get(\"foo\"));\n    results.add( drools.getRule().getMetaData().get(\"foo2\"));\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"consequence-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            List results = new ArrayList();
            session.setGlobal("results", results);
            session.insert((Object)new Person("Michael"));
            results = (List)session.getGlobal("results");
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)"bar", results.get(0));
            Assert.assertEquals((Object)"bar2", results.get(1));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMVELConsequenceWithMapsAndArrays() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport java.util.ArrayList\nimport java.util.HashMap\nglobal java.util.List list\nrule \"Test Rule\"\n    dialect \"mvel\"when\nthen\n    m = new HashMap();\n    l = new ArrayList();\n    l.add(\"first\");\n    m.put(\"content\", l);\n    System.out.println(((ArrayList)m[\"content\"])[0]);\n    list.add(((ArrayList)m[\"content\"])[0]);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"consequence-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nimport java.util.ArrayList\nimport java.util.HashMap\nglobal java.util.List list\nrule \"Test Rule\"\n    dialect \"mvel\"when\nthen\n    m = new HashMap();\n    l = new ArrayList();\n    l.add(\"first\");\n    m.put(\"content\", l);\n    System.out.println(((ArrayList)m[\"content\"])[0]);\n    list.add(((ArrayList)m[\"content\"])[0]);\nend"});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
            Assert.assertEquals((Object)"first", ((List)session.getGlobal("list")).get(0));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMVELConsequenceWithoutSemiColon1() {
        String drl = "package prg.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Pet.class.getCanonicalName() + ";\nrule test dialect 'mvel'\nwhen\n    $person:Person()\n    $pet:Pet()\nthen\n    delete($person) // some comment\n    delete($pet) // another comment\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"consequence-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
            ksession.addEventListener(wml);
            FactHandle personFH = ksession.insert((Object)new Person("Toni"));
            FactHandle petFH = ksession.insert((Object)new Pet("Toni"));
            int fired = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)fired);
            ArgumentCaptor retracts = ArgumentCaptor.forClass(ObjectDeletedEvent.class);
            ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectDeleted((ObjectDeletedEvent)retracts.capture());
            List values = retracts.getAllValues();
            Assert.assertThat((Object)((ObjectDeletedEvent)values.get(0)).getFactHandle(), (Matcher)CoreMatchers.is((Object)personFH));
            Assert.assertThat((Object)((ObjectDeletedEvent)values.get(1)).getFactHandle(), (Matcher)CoreMatchers.is((Object)petFH));
        }
        finally {
            ksession.dispose();
        }
    }
}

