/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import org.drools.compiler.integrationtests.SubnetworkTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class SubnetworkCEPTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SubnetworkCEPTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNPEOnFlushingOfUnlinkedPmem() {
        String drl = "import " + SubnetworkTest.A.class.getCanonicalName() + "\nimport " + SubnetworkTest.B.class.getCanonicalName() + "\nimport " + SubnetworkTest.C.class.getCanonicalName() + "\nrule R1 when\n    A()\n    B()\n    not( B() and C() )\nthen end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-cep-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            FactHandle fhA = ksession.insert((Object)new SubnetworkTest.A());
            ksession.insert((Object)new SubnetworkTest.C());
            ksession.fireAllRules();
            ksession.delete(fhA);
            ksession.insert((Object)new SubnetworkTest.A());
            ksession.insert((Object)new SubnetworkTest.B());
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }
}

