/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractCepEspTest {
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AbstractCepEspTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAssertBehaviorOnEntryPoints() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_AssertBehaviorOnEntryPoints.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            StockTick st1 = new StockTick(1L, "RHT", 10.0, 10L);
            StockTick st2 = new StockTick(1L, "RHT", 10.0, 10L);
            StockTick st3 = new StockTick(2L, "RHT", 15.0, 20L);
            AgendaEventListener ael1 = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael1);
            EntryPoint ep1 = ksession.getEntryPoint("stocktick stream");
            FactHandle fh1 = ep1.insert((Object)st1);
            FactHandle fh1_2 = ep1.insert((Object)st1);
            FactHandle fh2 = ep1.insert((Object)st2);
            FactHandle fh3 = ep1.insert((Object)st3);
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertSame((Object)fh1, (Object)fh1_2);
                Assert.assertNotSame((Object)fh1, (Object)fh2);
                Assert.assertNotSame((Object)fh1, (Object)fh3);
                Assert.assertNotSame((Object)fh2, (Object)fh3);
                ksession.fireAllRules();
                ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
            } else {
                Assert.assertSame((Object)fh1, (Object)fh1_2);
                Assert.assertSame((Object)fh1, (Object)fh2);
                Assert.assertNotSame((Object)fh1, (Object)fh3);
                ksession.fireAllRules();
                ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateFiring2() {
        String drl = "package org.test;\nimport " + StockTick.class.getCanonicalName() + ";\n global java.util.List list \ndeclare StockTick @role(event) end \nrule Tick when $s : StockTick() then System.out.println( $s ); end \nrule \"slidingTimeCount\"\nwhen\n\t$n: Number ( intValue > 0 ) from accumulate ( $e: StockTick() over window:time(3s), count($e))\nthen\n  list.add( $n ); \n  System.out.println( \"Events in last 3 seconds: \" + $n );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        ArrayList list = new ArrayList();
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ksession.setGlobal("list", list);
            for (int i = 1; i < 3; ++i) {
                StockTick event = new StockTick((long)(i - 1), "XXX", 1.0, 0L);
                clock.advanceTime(1001L, TimeUnit.MILLISECONDS);
                ksession.insert((Object)event);
                ksession.fireAllRules();
            }
            clock.advanceTime(3001L, TimeUnit.MILLISECONDS);
            StockTick event = new StockTick(3L, "XXX", 1.0, 0L);
            ksession.insert((Object)event);
            ksession.fireAllRules();
            clock.advanceTime(3001L, TimeUnit.MILLISECONDS);
            StockTick event2 = new StockTick(3L, "XXX", 1.0, 0L);
            ksession.insert((Object)event2);
            ksession.fireAllRules();
        }
        catch (Throwable throwable) {
            ksession.dispose();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals(Arrays.asList(1L, 2L, 1L, 1L), list);
            } else {
                Assert.assertEquals(Arrays.asList(1L, 2L, 1L), list);
            }
            throw throwable;
        }
        ksession.dispose();
        if (this.kieBaseTestConfiguration.isIdentity()) {
            Assert.assertEquals(Arrays.asList(1L, 2L, 1L, 1L), list);
        } else {
            Assert.assertEquals(Arrays.asList(1L, 2L, 1L), list);
        }
    }
}

