/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class FromSharingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FromSharingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharingFromWithoutHashCodeEquals() {
        String drl = "import " + PersonWithoutHashCodeEquals.class.getCanonicalName() + "\nimport " + AddressWithoutHashCodeEquals.class.getCanonicalName() + "\nrule R1 when\n  $p: PersonWithoutHashCodeEquals( age == 30 );\n  $a: AddressWithoutHashCodeEquals( street == null ) from $p.addresses;\nthen\n  System.out.println( \"R1 : \" + $a.getStreet() );\n  $a.setStreet( \"MyStreet#1\" );  update( $p );end\nrule R2 when\n  $p: PersonWithoutHashCodeEquals( age == 30 );\n  $a: AddressWithoutHashCodeEquals( street == null ) from $p.addresses;\nthen\n  System.out.println( \"R2 : \" + $a.getStreet() );\n  $a.setStreet( \"MyStreet#2\" );  update( $p );end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        try {
            AddressWithoutHashCodeEquals a = new AddressWithoutHashCodeEquals();
            a.setStreet(null);
            PersonWithoutHashCodeEquals p = new PersonWithoutHashCodeEquals();
            p.setName("John");
            p.setAge(30);
            p.getAddresses().add(a);
            kieSession.insert((Object)p);
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testFromSharingWithPropReactvityOnItsConstraint() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule \"R1\"\n    when\n        $p : Person()\n        Person( age > 10 ) from $p \n    then\n        modify ($p) {\n          setAge(5);\n        }\n        System.out.println( \"R1, \" + $p);\nend\n\nrule \"R2\"\n    when\n        $p : Person()\n        Person( age > 10 ) from $p \n    then\n        System.out.println( \"R2, \" + $p);\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession();
        ksession.insert((Object)new Person("John", 20));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    public static class PersonWithoutHashCodeEquals {
        private String name;
        private int age;
        private AddressWithoutHashCodeEquals address;
        private List<AddressWithoutHashCodeEquals> addresses = new ArrayList<AddressWithoutHashCodeEquals>();
        private Map<Object, AddressWithoutHashCodeEquals> namedAddresses = new HashMap<Object, AddressWithoutHashCodeEquals>(0);

        public PersonWithoutHashCodeEquals() {
        }

        public PersonWithoutHashCodeEquals(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public AddressWithoutHashCodeEquals getAddress() {
            return this.address;
        }

        public void setAddress(AddressWithoutHashCodeEquals address) {
            this.address = address;
        }

        public List<AddressWithoutHashCodeEquals> getAddresses() {
            return this.addresses;
        }

        public List getAddressesNoGenerics() {
            return this.addresses;
        }

        public void setAddresses(List<AddressWithoutHashCodeEquals> addresses) {
            this.addresses = addresses;
        }

        public void addAddress(AddressWithoutHashCodeEquals address) {
            this.addresses.add(address);
        }

        public Map<Object, AddressWithoutHashCodeEquals> getNamedAddresses() {
            return this.namedAddresses;
        }

        public void setNamedAddresses(Map<Object, AddressWithoutHashCodeEquals> namedAddresses) {
            this.namedAddresses = namedAddresses;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public int getDoubleAge() {
            return this.age * 2;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Integer getAgeAsInteger() {
            return this.age;
        }

        public String toString() {
            return "[Person name='" + this.name + " age='" + this.age + "']";
        }
    }

    public class AddressWithoutHashCodeEquals {
        private String street;

        public AddressWithoutHashCodeEquals() {
        }

        public AddressWithoutHashCodeEquals(String street) {
            this.street = street;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }
    }
}

