/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.FactWithList;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.Agenda;

@RunWith(value=Parameterized.class)
public class SharingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SharingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldAlphaShareBecauseSameConstantDespiteDifferentSyntax() {
        String drl1 = "package c;\nimport " + TestObject.class.getCanonicalName() + "\nrule fileArule1 when\n  TestObject(value == 1)\nthen\nend\n";
        String drl2 = "package iTzXzx;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestStaticUtils.class.getCanonicalName() + "\nrule fileBrule1 when\n  TestObject(value == TestStaticUtils.return1() )\nthen\nend\nrule fileBrule2 when\n  TestObject(value == 0 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldAlphaShareNotEqualsInDifferentPackages() {
        String drl1 = "package c;\nimport " + TestObject.class.getCanonicalName() + "\nrule fileArule1 when\n  TestObject(value >= 1 )\nthen\nend\n";
        String drl2 = "package iTzXzx;\nimport " + TestObject.class.getCanonicalName() + "\nrule fileBrule1 when\n  TestObject(value >= 1 )\nthen\nend\nrule fileBrule2 when\n  TestObject(value >= 2 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldAlphaShareNotEqualsInDifferentPackages2() {
        String drl1 = "package c;\nimport " + FactWithList.class.getCanonicalName() + "\n\nrule fileArule1 when\n  FactWithList(items contains \"test\")\nthen\nend\n";
        String drl2 = "package iTzXzx;\nimport " + FactWithList.class.getCanonicalName() + "\nrule fileBrule1 when\n  FactWithList(items contains \"test\")\nthen\nend\nrule fileBrule2 when\n  FactWithList(items contains \"testtest\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        KieSession kieSession = kbase.newKieSession();
        try {
            FactWithList factWithList = new FactWithList("test");
            kieSession.insert((Object)factWithList);
            Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubnetworkSharing() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\nglobal java.util.List list\nrule R1 agenda-group \"G2\" when\n    Number( intValue < 1 ) from accumulate (\n        A( $id : id )\n        and $b : B( parentId == $id )\n    ;count($b))\nthen\n    list.add(\"R1\");\nend\n\nrule R2 agenda-group \"G1\" when\n    Number( intValue < 1 ) from accumulate (\n        A( $id : id )\n        and $b : B( parentId == $id )\n\n    ;count($b))\nthen\n    list.add(\"R2\");\nend\n\nrule R3 agenda-group \"G1\" no-loop when\n    $a : A( $id : id )\nthen\n    modify($a) { setId($id + 1) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)new A(1));
            kieSession.insert((Object)new B(1));
            Agenda agenda = kieSession.getAgenda();
            agenda.getAgendaGroup("G2").setFocus();
            agenda.getAgendaGroup("G1").setFocus();
            kieSession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("R1"));
            Assert.assertTrue((boolean)list.contains("R2"));
        }
        finally {
            kieSession.dispose();
        }
    }

    public static class TestObject {
        private final Integer value;

        public TestObject(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static class B {
        private final int parentId;

        public B(int parentId) {
            this.parentId = parentId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }

    public static class A {
        private int id;

        public A(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    public static class TestStaticUtils {
        public static int return1() {
            return 1;
        }
    }
}

