/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class StreamsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public StreamsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventAssertion() {
        String drl = "package org.drools.compiler\n\nimport " + StockTick.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\ndeclare StockTick\n    @role( event )\nend\n\nrule \"Test entry point\"\nwhen\n    $st : StockTick( company == \"ACME\", price > 10 ) from entry-point StockStream\nthen\n    results.add( $st );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis());
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis());
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis());
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis());
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            Assert.assertNotNull((Object)handle1);
            Assert.assertNotNull((Object)handle2);
            Assert.assertNotNull((Object)handle3);
            Assert.assertNotNull((Object)handle4);
            Assert.assertTrue((boolean)handle1.isEvent());
            Assert.assertTrue((boolean)handle2.isEvent());
            Assert.assertTrue((boolean)handle3.isEvent());
            Assert.assertTrue((boolean)handle4.isEvent());
            session.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
            StockTick tick7 = new StockTick(7L, "ACME", 15.0, System.currentTimeMillis());
            StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
            EntryPoint entry = session.getEntryPoint("StockStream");
            InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
            InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
            InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
            InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
            Assert.assertNotNull((Object)handle5);
            Assert.assertNotNull((Object)handle6);
            Assert.assertNotNull((Object)handle7);
            Assert.assertNotNull((Object)handle8);
            Assert.assertTrue((boolean)handle5.isEvent());
            Assert.assertTrue((boolean)handle6.isEvent());
            Assert.assertTrue((boolean)handle7.isEvent());
            Assert.assertTrue((boolean)handle8.isEvent());
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertSame((Object)tick7, results.get(0));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntryPointReference() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_EntryPointReference.drl"});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
            StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
            StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
            EntryPoint entry = session.getEntryPoint("stream1");
            InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
            InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
            InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
            InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
            Assert.assertNotNull((Object)handle5);
            Assert.assertNotNull((Object)handle6);
            Assert.assertNotNull((Object)handle7);
            Assert.assertNotNull((Object)handle8);
            Assert.assertTrue((boolean)handle5.isEvent());
            Assert.assertTrue((boolean)handle6.isEvent());
            Assert.assertTrue((boolean)handle7.isEvent());
            Assert.assertTrue((boolean)handle8.isEvent());
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertSame((Object)tick7, results.get(0));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testModifyRetracOnEntryPointFacts() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List results;\n\ndeclare StockTick\n    @role( event )\nend\n\nrule \"Test entry point 1\"\nwhen\n    $st : StockTick( company == \"ACME\", price > 10 && < 100 ) from entry-point \"stream1\"\nthen\n    results.add( Double.valueOf( $st.getPrice() ) );\n    modify( $st ) { setPrice( 110 ) }\nend\n\nrule \"Test entry point 2\"\nwhen\n    $st : StockTick( company == \"ACME\", price > 100 ) from entry-point \"stream1\"\nthen\n    results.add( Double.valueOf( $st.getPrice() ) );\n    delete( $st );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
            StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
            StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
            EntryPoint entry = session.getEntryPoint("stream1");
            InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
            InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
            InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
            InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
            Assert.assertNotNull((Object)handle5);
            Assert.assertNotNull((Object)handle6);
            Assert.assertNotNull((Object)handle7);
            Assert.assertNotNull((Object)handle8);
            Assert.assertTrue((boolean)handle5.isEvent());
            Assert.assertTrue((boolean)handle6.isEvent());
            Assert.assertTrue((boolean)handle7.isEvent());
            Assert.assertTrue((boolean)handle8.isEvent());
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)30L, (long)((Number)results.get(0)).intValue());
            Assert.assertEquals((long)110L, (long)((Number)results.get(1)).intValue());
            Assert.assertEquals((long)3L, (long)entry.getObjects().size());
            Assert.assertEquals((long)0L, (long)session.getObjects().size());
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyOnEntryPointFacts() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n        @role ( event )\nend\nrule R1 salience 100\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep1\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\nrule R2 salience 90\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep2\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\nrule R3 salience 80\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep3\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            EntryPoint ep1 = ksession.getEntryPoint("ep1");
            EntryPoint ep2 = ksession.getEntryPoint("ep2");
            EntryPoint ep3 = ksession.getEntryPoint("ep3");
            ep1.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            ep2.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            ep3.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            int rulesFired = ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)rulesFired);
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            List aafe = captor.getAllValues();
            Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R1"));
            Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(1)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R2"));
            Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(2)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R3"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEntryPointWithAccumulateAndMVEL() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nrule R1 dialect 'mvel'\n    when\n        $n : Number() from accumulate( \n                 StockTick() from entry-point ep1,\n                 count(1))    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            EntryPoint ep1 = ksession.getEntryPoint("ep1");
            ep1.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            int rulesFired = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rulesFired);
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            List aafe = captor.getAllValues();
            Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R1"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testGetEntryPointList() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_EntryPointReference.drl"});
        KieSession session = kbase.newKieSession();
        try {
            EntryPoint def = session.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
            EntryPoint s1 = session.getEntryPoint("stream1");
            EntryPoint s2 = session.getEntryPoint("stream2");
            EntryPoint s3 = session.getEntryPoint("stream3");
            Collection eps = session.getEntryPoints();
            Assert.assertEquals((long)4L, (long)eps.size());
            Assert.assertTrue((boolean)eps.contains(def));
            Assert.assertTrue((boolean)eps.contains(s1));
            Assert.assertTrue((boolean)eps.contains(s2));
            Assert.assertTrue((boolean)eps.contains(s3));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventDoesNotExpireIfNotInPattern() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role( event )\n    @expires( 1s )\nend\n\nrule X\nwhen\n    eval( true )\nthen \n    // no-op\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
            ksession.addEventListener(wml);
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            StockTick st1 = new StockTick(1L, "RHT", 100.0, 1000L);
            StockTick st2 = new StockTick(2L, "RHT", 100.0, 1000L);
            ksession.insert((Object)st1);
            ksession.insert((Object)st2);
            ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
            Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((Object)ksession.getObjects(), (Matcher)CoreMatchers.hasItems((Object[])new Object[]{st1, st2}));
            ksession.fireAllRules();
            clock.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventExpirationSetToZero() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role( event )\n    @expires( 0 )\nend\n\nrule X\nwhen\n    StockTick()\nthen \n    // no-op\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
            ksession.addEventListener(wml);
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            StockTick st1 = new StockTick(1L, "RHT", 100.0, 1000L);
            StockTick st2 = new StockTick(2L, "RHT", 100.0, 1000L);
            ksession.insert((Object)st1);
            ksession.insert((Object)st2);
            Assert.assertThat((Object)ksession.fireAllRules(), (Matcher)CoreMatchers.equalTo((Object)2));
            ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
            Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((Object)ksession.getObjects(), (Matcher)CoreMatchers.hasItems((Object[])new Object[]{st1, st2}));
            clock.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testEventExpirationValue() {
        String drl1 = "package org.drools.pkg1\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role(event)\nend\nrule X\nwhen\n    StockTick()\nthen\nend\n";
        String drl2 = "package org.drools.pkg2\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role(event)\nend\nrule X\nwhen\n    StockTick()\nthen\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        List otns = kbase.getRete().getObjectTypeNodes();
        ClassObjectType stot = new ClassObjectType(StockTick.class);
        for (ObjectTypeNode otn : otns) {
            if (!otn.getObjectType().isAssignableFrom((ObjectType)stot)) continue;
            Assert.assertEquals((long)-1L, (long)otn.getExpirationOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDeclaredEntryPoint() {
        String drl = "package org.jboss.qa.brms.declaredep\ndeclare entry-point UnusedEntryPoint\nend\nrule HelloWorld\n    when\n        String( ) from entry-point UsedEntryPoint\n    then\n        // consequences\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.jboss.qa.brms.declaredep\ndeclare entry-point UnusedEntryPoint\nend\nrule HelloWorld\n    when\n        String( ) from entry-point UsedEntryPoint\n    then\n        // consequences\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            Assert.assertNotNull((Object)ksession.getEntryPoint("UsedEntryPoint"));
            Assert.assertNotNull((Object)ksession.getEntryPoint("UnusedEntryPoint"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWindowDeclaration() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role(event)\nend\ndeclare window RedHatTicks\n    StockTick( company == 'RHT' )\n               over window:length(5)\n               from entry-point ticks\nend\nrule X\nwhen\n    accumulate( $s : StockTick( price > 20 ) from window RedHatTicks,\n                $sum : sum( $s.getPrice() ),\n                $cnt : count( $s ) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            EntryPoint ep = ksession.getEntryPoint("ticks");
            ep.insert((Object)new StockTick(1L, "ACME", 20.0, 1000L));
            ep.insert((Object)new StockTick(2L, "RHT", 20.0, 1000L));
            ep.insert((Object)new StockTick(3L, "RHT", 30.0, 1000L));
            ep.insert((Object)new StockTick(4L, "ACME", 30.0, 1000L));
            ep.insert((Object)new StockTick(5L, "RHT", 25.0, 1000L));
            ep.insert((Object)new StockTick(6L, "ACME", 10.0, 1000L));
            ep.insert((Object)new StockTick(7L, "RHT", 10.0, 1000L));
            ep.insert((Object)new StockTick(8L, "RHT", 40.0, 1000L));
            ksession.fireAllRules();
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            AfterMatchFiredEvent aafe = (AfterMatchFiredEvent)captor.getValue();
            Assert.assertThat((Object)((Number)aafe.getMatch().getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)95));
            Assert.assertThat((Object)((Number)aafe.getMatch().getDeclarationValue("$cnt")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testWindowDeclaration2() {
        String drl = "package org.drools.compiler\ndeclare Double\n    @role(event)\nend\ndeclare window Streem\n    Double() over window:length( 10 ) from entry-point data\nend\nrule \"See\"\nwhen\n    $sum : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\ndeclare Double\n    @role(event)\nend\ndeclare window Streem\n    Double() over window:length( 10 ) from entry-point data\nend\nrule \"See\"\nwhen\n    $sum : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            EntryPoint ep = ksession.getEntryPoint("data");
            ep.insert((Object)10.0);
            ep.insert((Object)11.0);
            ep.insert((Object)12.0);
            ksession.fireAllRules();
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            AfterMatchFiredEvent aafe = (AfterMatchFiredEvent)captor.getValue();
            Assert.assertThat((Object)((Number)aafe.getMatch().getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)33));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleWindows() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n    @role(event)\nend\nrule FaultsCoincide\nwhen\n   f1 : StockTick( company == \"RHT\" ) over window:length( 1 )\n   f2 : StockTick( company == \"JBW\" ) over window:length( 1 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            StockTick st1 = new StockTick(1L, "RHT", 10.0, 1000L);
            ksession.insert((Object)st1);
            StockTick st2 = new StockTick(2L, "JBW", 10.0, 1000L);
            ksession.insert((Object)st2);
            ksession.fireAllRules();
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            AfterMatchFiredEvent aafe = (AfterMatchFiredEvent)captor.getValue();
            Assert.assertThat((Object)aafe.getMatch().getDeclarationValue("f1"), (Matcher)CoreMatchers.is((Object)st1));
            Assert.assertThat((Object)aafe.getMatch().getDeclarationValue("f2"), (Matcher)CoreMatchers.is((Object)st2));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testWindowWithEntryPointCompilationError() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\ndeclare window X\n   Cheese( type == \"gorgonzola\" ) over window:time(1m) from entry-point Z\nend\nrule R when\n   $c : Cheese( price < 100 ) from window X\nthen\n   System.out.println($c);\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        ((ListAssert)Assertions.assertThat((List)kieBuilder.getResults().getMessages()).withFailMessage("Should have raised a compilation error as Cheese is not declared as an event.", new Object[0])).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAtomicActivationFiring() throws Exception {
        String drl = "package org.drools.compiler.test\ndeclare Event\n   @role(event)\n   name : String\nend\ndeclare Monitor\n   @role(event)\n   event : Event\n   name : String\nend\n\nrule \"start monitoring\"\nwhen\n    $e : Event( $in : name )\n    not Monitor( name == $in )\nthen\n    Monitor m = new Monitor( $e, $in );\n    insert( m );\nend\n\nrule \"stop monitoring\"\ntimer( int: 1s )\nwhen\n    $m : Monitor( $in : name )\n    $e : Event( name == $in )\nthen\n    retract( $m );\n    retract( $m.getEvent() );\nend\nrule \"halt\"\nsalience -1\nwhen\n    not Event( )\nthen\n    drools.halt();\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"stream-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test\ndeclare Event\n   @role(event)\n   name : String\nend\ndeclare Monitor\n   @role(event)\n   event : Event\n   name : String\nend\n\nrule \"start monitoring\"\nwhen\n    $e : Event( $in : name )\n    not Monitor( name == $in )\nthen\n    Monitor m = new Monitor( $e, $in );\n    insert( m );\nend\n\nrule \"stop monitoring\"\ntimer( int: 1s )\nwhen\n    $m : Monitor( $in : name )\n    $e : Event( name == $in )\nthen\n    retract( $m );\n    retract( $m.getEvent() );\nend\nrule \"halt\"\nsalience -1\nwhen\n    not Event( )\nthen\n    drools.halt();\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
            FactType eventType = kbase.getFactType("org.drools.compiler.test", "Event");
            Object event = eventType.newInstance();
            eventType.set(event, "name", (Object)"myName");
            ksession.insert(event);
            ksession.fireUntilHalt();
        }
        finally {
            ksession.dispose();
        }
    }
}

